package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, float) -> void}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortFloatToNilE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param fl argument 2
     * @throws E if the operation cannot be completed
     */
    void call(short sh, float fl) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (float) -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (float fl) -> void} that calls
     *      {@code f.call(sh, fl)}.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.FloatToNilE<E>
    bind(ShortFloatToNilE<E> f, short sh) {
        return (fl) -> f.call(sh, fl);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (float) -> void}.
     *
     * @param sh argument 1
     * @return a new function {@code (float fl) -> void} that calls
     *      {@code this.call(sh, fl)}.
     */
    default net.mintern.functions.unary.checked.FloatToNilE<E> bind(short sh) {
        return ShortFloatToNilE.bind(this, sh);
    }

    /**
     * Binds {@code (fl)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param fl argument 2
     * @return a new function {@code (short sh) -> void} that calls
     *      {@code f.call(sh, fl)}.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToNilE<E>
    rbind(ShortFloatToNilE<E> f, float fl) {
        return (sh) -> f.call(sh, fl);
    }

    /**
     * Binds {@code (fl)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param fl argument 2
     * @return a new function {@code (short sh) -> void} that calls
     *      {@code this.call(sh, fl)}.
     */
    default net.mintern.functions.unary.checked.ShortToNilE<E> rbind(float fl) {
        return ShortFloatToNilE.rbind(this, fl);
    }

    /**
     * Binds {@code (sh, fl)} to {@code f}, returning a new function
     * of type {@code () -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param fl argument 2
     * @return a new function {@code () -> void} that calls
     *      {@code f.call(sh, fl)}.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToNilE<E>
    bind(ShortFloatToNilE<E> f, short sh, float fl) {
        return () -> f.call(sh, fl);
    }

    /**
     * Binds {@code (sh, fl)} to {@code this}, returning a new function
     * of type {@code () -> void}.
     *
     * @param sh argument 1
     * @param fl argument 2
     * @return a new function {@code () -> void} that calls
     *      {@code this.call(sh, fl)}.
     */
    default net.mintern.functions.nullary.checked.NilToNilE<E> bind(short sh, float fl) {
        return ShortFloatToNilE.bind(this, sh, fl);
    }
}
