package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, int) -> boolean}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortIntToBoolE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param i argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    boolean call(short sh, int i) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (int) -> boolean}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (int i) -> boolean} that calls
     *      {@code f.call(sh, i)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.IntToBoolE<E>
    bind(ShortIntToBoolE<E> f, short sh) {
        return (i) -> f.call(sh, i);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (int) -> boolean}.
     *
     * @param sh argument 1
     * @return a new function {@code (int i) -> boolean} that calls
     *      {@code this.call(sh, i)} and returns the result.
     */
    default net.mintern.functions.unary.checked.IntToBoolE<E> bind(short sh) {
        return ShortIntToBoolE.bind(this, sh);
    }

    /**
     * Binds {@code (i)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> boolean}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i argument 2
     * @return a new function {@code (short sh) -> boolean} that calls
     *      {@code f.call(sh, i)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToBoolE<E>
    rbind(ShortIntToBoolE<E> f, int i) {
        return (sh) -> f.call(sh, i);
    }

    /**
     * Binds {@code (i)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> boolean}.
     *
     * @param i argument 2
     * @return a new function {@code (short sh) -> boolean} that calls
     *      {@code this.call(sh, i)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToBoolE<E> rbind(int i) {
        return ShortIntToBoolE.rbind(this, i);
    }

    /**
     * Binds {@code (sh, i)} to {@code f}, returning a new function
     * of type {@code () -> boolean}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param i argument 2
     * @return a new function {@code () -> boolean} that calls
     *      {@code f.call(sh, i)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToBoolE<E>
    bind(ShortIntToBoolE<E> f, short sh, int i) {
        return () -> f.call(sh, i);
    }

    /**
     * Binds {@code (sh, i)} to {@code this}, returning a new function
     * of type {@code () -> boolean}.
     *
     * @param sh argument 1
     * @param i argument 2
     * @return a new function {@code () -> boolean} that calls
     *      {@code this.call(sh, i)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToBoolE<E> bind(short sh, int i) {
        return ShortIntToBoolE.bind(this, sh, i);
    }
}
