package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, int) -> double}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortIntToDblE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param i argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    double call(short sh, int i) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (int) -> double}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (int i) -> double} that calls
     *      {@code f.call(sh, i)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.IntToDblE<E>
    bind(ShortIntToDblE<E> f, short sh) {
        return (i) -> f.call(sh, i);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (int) -> double}.
     *
     * @param sh argument 1
     * @return a new function {@code (int i) -> double} that calls
     *      {@code this.call(sh, i)} and returns the result.
     */
    default net.mintern.functions.unary.checked.IntToDblE<E> bind(short sh) {
        return ShortIntToDblE.bind(this, sh);
    }

    /**
     * Binds {@code (i)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> double}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i argument 2
     * @return a new function {@code (short sh) -> double} that calls
     *      {@code f.call(sh, i)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToDblE<E>
    rbind(ShortIntToDblE<E> f, int i) {
        return (sh) -> f.call(sh, i);
    }

    /**
     * Binds {@code (i)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> double}.
     *
     * @param i argument 2
     * @return a new function {@code (short sh) -> double} that calls
     *      {@code this.call(sh, i)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToDblE<E> rbind(int i) {
        return ShortIntToDblE.rbind(this, i);
    }

    /**
     * Binds {@code (sh, i)} to {@code f}, returning a new function
     * of type {@code () -> double}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param i argument 2
     * @return a new function {@code () -> double} that calls
     *      {@code f.call(sh, i)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToDblE<E>
    bind(ShortIntToDblE<E> f, short sh, int i) {
        return () -> f.call(sh, i);
    }

    /**
     * Binds {@code (sh, i)} to {@code this}, returning a new function
     * of type {@code () -> double}.
     *
     * @param sh argument 1
     * @param i argument 2
     * @return a new function {@code () -> double} that calls
     *      {@code this.call(sh, i)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToDblE<E> bind(short sh, int i) {
        return ShortIntToDblE.bind(this, sh, i);
    }
}
