package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, int) -> void}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortIntToNilE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param i argument 2
     * @throws E if the operation cannot be completed
     */
    void call(short sh, int i) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (int) -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (int i) -> void} that calls
     *      {@code f.call(sh, i)}.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.IntToNilE<E>
    bind(ShortIntToNilE<E> f, short sh) {
        return (i) -> f.call(sh, i);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (int) -> void}.
     *
     * @param sh argument 1
     * @return a new function {@code (int i) -> void} that calls
     *      {@code this.call(sh, i)}.
     */
    default net.mintern.functions.unary.checked.IntToNilE<E> bind(short sh) {
        return ShortIntToNilE.bind(this, sh);
    }

    /**
     * Binds {@code (i)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i argument 2
     * @return a new function {@code (short sh) -> void} that calls
     *      {@code f.call(sh, i)}.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToNilE<E>
    rbind(ShortIntToNilE<E> f, int i) {
        return (sh) -> f.call(sh, i);
    }

    /**
     * Binds {@code (i)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param i argument 2
     * @return a new function {@code (short sh) -> void} that calls
     *      {@code this.call(sh, i)}.
     */
    default net.mintern.functions.unary.checked.ShortToNilE<E> rbind(int i) {
        return ShortIntToNilE.rbind(this, i);
    }

    /**
     * Binds {@code (sh, i)} to {@code f}, returning a new function
     * of type {@code () -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param i argument 2
     * @return a new function {@code () -> void} that calls
     *      {@code f.call(sh, i)}.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToNilE<E>
    bind(ShortIntToNilE<E> f, short sh, int i) {
        return () -> f.call(sh, i);
    }

    /**
     * Binds {@code (sh, i)} to {@code this}, returning a new function
     * of type {@code () -> void}.
     *
     * @param sh argument 1
     * @param i argument 2
     * @return a new function {@code () -> void} that calls
     *      {@code this.call(sh, i)}.
     */
    default net.mintern.functions.nullary.checked.NilToNilE<E> bind(short sh, int i) {
        return ShortIntToNilE.bind(this, sh, i);
    }
}
