package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, int) -> R}.
 *
 * @param <R> the type of the return value
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortIntToObjE<R, E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param i argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    R call(short sh, int i) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (int) -> R}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (int i) -> R} that calls
     *      {@code f.call(sh, i)} and returns the result.
     */
    static <R, E extends Exception> net.mintern.functions.unary.checked.IntToObjE<R, E>
    bind(ShortIntToObjE<R, E> f, short sh) {
        return (i) -> f.call(sh, i);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (int) -> R}.
     *
     * @param sh argument 1
     * @return a new function {@code (int i) -> R} that calls
     *      {@code this.call(sh, i)} and returns the result.
     */
    default net.mintern.functions.unary.checked.IntToObjE<R, E> bind(short sh) {
        return ShortIntToObjE.bind(this, sh);
    }

    /**
     * Binds {@code (i)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i argument 2
     * @return a new function {@code (short sh) -> R} that calls
     *      {@code f.call(sh, i)} and returns the result.
     */
    static <R, E extends Exception> net.mintern.functions.unary.checked.ShortToObjE<R, E>
    rbind(ShortIntToObjE<R, E> f, int i) {
        return (sh) -> f.call(sh, i);
    }

    /**
     * Binds {@code (i)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param i argument 2
     * @return a new function {@code (short sh) -> R} that calls
     *      {@code this.call(sh, i)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToObjE<R, E> rbind(int i) {
        return ShortIntToObjE.rbind(this, i);
    }

    /**
     * Binds {@code (sh, i)} to {@code f}, returning a new function
     * of type {@code () -> R}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param i argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code f.call(sh, i)} and returns the result.
     */
    @SuppressWarnings("unchecked") // maven spuriously warns about a type error in this case
    static <R, E extends Exception> net.mintern.functions.nullary.checked.NilToObjE<R, E>
    bind(ShortIntToObjE<R, E> f, short sh, int i) {
        return () -> f.call(sh, i);
    }

    /**
     * Binds {@code (sh, i)} to {@code this}, returning a new function
     * of type {@code () -> R}.
     *
     * @param sh argument 1
     * @param i argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code this.call(sh, i)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToObjE<R, E> bind(short sh, int i) {
        return ShortIntToObjE.bind(this, sh, i);
    }
}
