package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, long) -> char}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortLongToCharE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param l argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    char call(short sh, long l) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (long) -> char}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (long l) -> char} that calls
     *      {@code f.call(sh, l)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.LongToCharE<E>
    bind(ShortLongToCharE<E> f, short sh) {
        return (l) -> f.call(sh, l);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (long) -> char}.
     *
     * @param sh argument 1
     * @return a new function {@code (long l) -> char} that calls
     *      {@code this.call(sh, l)} and returns the result.
     */
    default net.mintern.functions.unary.checked.LongToCharE<E> bind(short sh) {
        return ShortLongToCharE.bind(this, sh);
    }

    /**
     * Binds {@code (l)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> char}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l argument 2
     * @return a new function {@code (short sh) -> char} that calls
     *      {@code f.call(sh, l)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToCharE<E>
    rbind(ShortLongToCharE<E> f, long l) {
        return (sh) -> f.call(sh, l);
    }

    /**
     * Binds {@code (l)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> char}.
     *
     * @param l argument 2
     * @return a new function {@code (short sh) -> char} that calls
     *      {@code this.call(sh, l)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToCharE<E> rbind(long l) {
        return ShortLongToCharE.rbind(this, l);
    }

    /**
     * Binds {@code (sh, l)} to {@code f}, returning a new function
     * of type {@code () -> char}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param l argument 2
     * @return a new function {@code () -> char} that calls
     *      {@code f.call(sh, l)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToCharE<E>
    bind(ShortLongToCharE<E> f, short sh, long l) {
        return () -> f.call(sh, l);
    }

    /**
     * Binds {@code (sh, l)} to {@code this}, returning a new function
     * of type {@code () -> char}.
     *
     * @param sh argument 1
     * @param l argument 2
     * @return a new function {@code () -> char} that calls
     *      {@code this.call(sh, l)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToCharE<E> bind(short sh, long l) {
        return ShortLongToCharE.bind(this, sh, l);
    }
}
