package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, long) -> double}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortLongToDblE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param l argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    double call(short sh, long l) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (long) -> double}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (long l) -> double} that calls
     *      {@code f.call(sh, l)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.LongToDblE<E>
    bind(ShortLongToDblE<E> f, short sh) {
        return (l) -> f.call(sh, l);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (long) -> double}.
     *
     * @param sh argument 1
     * @return a new function {@code (long l) -> double} that calls
     *      {@code this.call(sh, l)} and returns the result.
     */
    default net.mintern.functions.unary.checked.LongToDblE<E> bind(short sh) {
        return ShortLongToDblE.bind(this, sh);
    }

    /**
     * Binds {@code (l)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> double}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l argument 2
     * @return a new function {@code (short sh) -> double} that calls
     *      {@code f.call(sh, l)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToDblE<E>
    rbind(ShortLongToDblE<E> f, long l) {
        return (sh) -> f.call(sh, l);
    }

    /**
     * Binds {@code (l)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> double}.
     *
     * @param l argument 2
     * @return a new function {@code (short sh) -> double} that calls
     *      {@code this.call(sh, l)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToDblE<E> rbind(long l) {
        return ShortLongToDblE.rbind(this, l);
    }

    /**
     * Binds {@code (sh, l)} to {@code f}, returning a new function
     * of type {@code () -> double}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param l argument 2
     * @return a new function {@code () -> double} that calls
     *      {@code f.call(sh, l)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToDblE<E>
    bind(ShortLongToDblE<E> f, short sh, long l) {
        return () -> f.call(sh, l);
    }

    /**
     * Binds {@code (sh, l)} to {@code this}, returning a new function
     * of type {@code () -> double}.
     *
     * @param sh argument 1
     * @param l argument 2
     * @return a new function {@code () -> double} that calls
     *      {@code this.call(sh, l)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToDblE<E> bind(short sh, long l) {
        return ShortLongToDblE.bind(this, sh, l);
    }
}
