package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, long) -> int}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortLongToIntE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param l argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    int call(short sh, long l) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (long) -> int}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (long l) -> int} that calls
     *      {@code f.call(sh, l)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.LongToIntE<E>
    bind(ShortLongToIntE<E> f, short sh) {
        return (l) -> f.call(sh, l);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (long) -> int}.
     *
     * @param sh argument 1
     * @return a new function {@code (long l) -> int} that calls
     *      {@code this.call(sh, l)} and returns the result.
     */
    default net.mintern.functions.unary.checked.LongToIntE<E> bind(short sh) {
        return ShortLongToIntE.bind(this, sh);
    }

    /**
     * Binds {@code (l)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> int}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l argument 2
     * @return a new function {@code (short sh) -> int} that calls
     *      {@code f.call(sh, l)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToIntE<E>
    rbind(ShortLongToIntE<E> f, long l) {
        return (sh) -> f.call(sh, l);
    }

    /**
     * Binds {@code (l)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> int}.
     *
     * @param l argument 2
     * @return a new function {@code (short sh) -> int} that calls
     *      {@code this.call(sh, l)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToIntE<E> rbind(long l) {
        return ShortLongToIntE.rbind(this, l);
    }

    /**
     * Binds {@code (sh, l)} to {@code f}, returning a new function
     * of type {@code () -> int}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param l argument 2
     * @return a new function {@code () -> int} that calls
     *      {@code f.call(sh, l)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToIntE<E>
    bind(ShortLongToIntE<E> f, short sh, long l) {
        return () -> f.call(sh, l);
    }

    /**
     * Binds {@code (sh, l)} to {@code this}, returning a new function
     * of type {@code () -> int}.
     *
     * @param sh argument 1
     * @param l argument 2
     * @return a new function {@code () -> int} that calls
     *      {@code this.call(sh, l)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToIntE<E> bind(short sh, long l) {
        return ShortLongToIntE.bind(this, sh, l);
    }
}
