package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, U) -> byte}.
 *
 * @param <U> the type of argument 2
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortObjToByteE<U, E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param u argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    byte call(short sh, U u) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (U) -> byte}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (U u) -> byte} that calls
     *      {@code f.call(sh, u)} and returns the result.
     */
    static <U, E extends Exception> net.mintern.functions.unary.checked.ObjToByteE<U, E>
    bind(ShortObjToByteE<U, E> f, short sh) {
        return (u) -> f.call(sh, u);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (U) -> byte}.
     *
     * @param sh argument 1
     * @return a new function {@code (U u) -> byte} that calls
     *      {@code this.call(sh, u)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ObjToByteE<U, E> bind(short sh) {
        return ShortObjToByteE.bind(this, sh);
    }

    /**
     * Binds {@code (u)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> byte}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param u argument 2
     * @return a new function {@code (short sh) -> byte} that calls
     *      {@code f.call(sh, u)} and returns the result.
     */
    static <U, E extends Exception> net.mintern.functions.unary.checked.ShortToByteE<E>
    rbind(ShortObjToByteE<U, E> f, U u) {
        return (sh) -> f.call(sh, u);
    }

    /**
     * Binds {@code (u)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> byte}.
     *
     * @param u argument 2
     * @return a new function {@code (short sh) -> byte} that calls
     *      {@code this.call(sh, u)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToByteE<E> rbind(U u) {
        return ShortObjToByteE.rbind(this, u);
    }

    /**
     * Binds {@code (sh, u)} to {@code f}, returning a new function
     * of type {@code () -> byte}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param u argument 2
     * @return a new function {@code () -> byte} that calls
     *      {@code f.call(sh, u)} and returns the result.
     */
    static <U, E extends Exception> net.mintern.functions.nullary.checked.NilToByteE<E>
    bind(ShortObjToByteE<U, E> f, short sh, U u) {
        return () -> f.call(sh, u);
    }

    /**
     * Binds {@code (sh, u)} to {@code this}, returning a new function
     * of type {@code () -> byte}.
     *
     * @param sh argument 1
     * @param u argument 2
     * @return a new function {@code () -> byte} that calls
     *      {@code this.call(sh, u)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToByteE<E> bind(short sh, U u) {
        return ShortObjToByteE.bind(this, sh, u);
    }
}
