package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, U) -> char}.
 *
 * @param <U> the type of argument 2
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortObjToCharE<U, E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param u argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    char call(short sh, U u) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (U) -> char}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (U u) -> char} that calls
     *      {@code f.call(sh, u)} and returns the result.
     */
    static <U, E extends Exception> net.mintern.functions.unary.checked.ObjToCharE<U, E>
    bind(ShortObjToCharE<U, E> f, short sh) {
        return (u) -> f.call(sh, u);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (U) -> char}.
     *
     * @param sh argument 1
     * @return a new function {@code (U u) -> char} that calls
     *      {@code this.call(sh, u)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ObjToCharE<U, E> bind(short sh) {
        return ShortObjToCharE.bind(this, sh);
    }

    /**
     * Binds {@code (u)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> char}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param u argument 2
     * @return a new function {@code (short sh) -> char} that calls
     *      {@code f.call(sh, u)} and returns the result.
     */
    static <U, E extends Exception> net.mintern.functions.unary.checked.ShortToCharE<E>
    rbind(ShortObjToCharE<U, E> f, U u) {
        return (sh) -> f.call(sh, u);
    }

    /**
     * Binds {@code (u)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> char}.
     *
     * @param u argument 2
     * @return a new function {@code (short sh) -> char} that calls
     *      {@code this.call(sh, u)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToCharE<E> rbind(U u) {
        return ShortObjToCharE.rbind(this, u);
    }

    /**
     * Binds {@code (sh, u)} to {@code f}, returning a new function
     * of type {@code () -> char}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param u argument 2
     * @return a new function {@code () -> char} that calls
     *      {@code f.call(sh, u)} and returns the result.
     */
    static <U, E extends Exception> net.mintern.functions.nullary.checked.NilToCharE<E>
    bind(ShortObjToCharE<U, E> f, short sh, U u) {
        return () -> f.call(sh, u);
    }

    /**
     * Binds {@code (sh, u)} to {@code this}, returning a new function
     * of type {@code () -> char}.
     *
     * @param sh argument 1
     * @param u argument 2
     * @return a new function {@code () -> char} that calls
     *      {@code this.call(sh, u)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToCharE<E> bind(short sh, U u) {
        return ShortObjToCharE.bind(this, sh, u);
    }
}
