package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, U) -> double}.
 *
 * @param <U> the type of argument 2
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortObjToDblE<U, E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param u argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    double call(short sh, U u) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (U) -> double}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (U u) -> double} that calls
     *      {@code f.call(sh, u)} and returns the result.
     */
    static <U, E extends Exception> net.mintern.functions.unary.checked.ObjToDblE<U, E>
    bind(ShortObjToDblE<U, E> f, short sh) {
        return (u) -> f.call(sh, u);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (U) -> double}.
     *
     * @param sh argument 1
     * @return a new function {@code (U u) -> double} that calls
     *      {@code this.call(sh, u)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ObjToDblE<U, E> bind(short sh) {
        return ShortObjToDblE.bind(this, sh);
    }

    /**
     * Binds {@code (u)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> double}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param u argument 2
     * @return a new function {@code (short sh) -> double} that calls
     *      {@code f.call(sh, u)} and returns the result.
     */
    static <U, E extends Exception> net.mintern.functions.unary.checked.ShortToDblE<E>
    rbind(ShortObjToDblE<U, E> f, U u) {
        return (sh) -> f.call(sh, u);
    }

    /**
     * Binds {@code (u)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> double}.
     *
     * @param u argument 2
     * @return a new function {@code (short sh) -> double} that calls
     *      {@code this.call(sh, u)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToDblE<E> rbind(U u) {
        return ShortObjToDblE.rbind(this, u);
    }

    /**
     * Binds {@code (sh, u)} to {@code f}, returning a new function
     * of type {@code () -> double}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param u argument 2
     * @return a new function {@code () -> double} that calls
     *      {@code f.call(sh, u)} and returns the result.
     */
    static <U, E extends Exception> net.mintern.functions.nullary.checked.NilToDblE<E>
    bind(ShortObjToDblE<U, E> f, short sh, U u) {
        return () -> f.call(sh, u);
    }

    /**
     * Binds {@code (sh, u)} to {@code this}, returning a new function
     * of type {@code () -> double}.
     *
     * @param sh argument 1
     * @param u argument 2
     * @return a new function {@code () -> double} that calls
     *      {@code this.call(sh, u)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToDblE<E> bind(short sh, U u) {
        return ShortObjToDblE.bind(this, sh, u);
    }
}
