package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, U) -> void}.
 *
 * @param <U> the type of argument 2
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortObjToNilE<U, E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param u argument 2
     * @throws E if the operation cannot be completed
     */
    void call(short sh, U u) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (U) -> void}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (U u) -> void} that calls
     *      {@code f.call(sh, u)}.
     */
    static <U, E extends Exception> net.mintern.functions.unary.checked.ObjToNilE<U, E>
    bind(ShortObjToNilE<U, E> f, short sh) {
        return (u) -> f.call(sh, u);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (U) -> void}.
     *
     * @param sh argument 1
     * @return a new function {@code (U u) -> void} that calls
     *      {@code this.call(sh, u)}.
     */
    default net.mintern.functions.unary.checked.ObjToNilE<U, E> bind(short sh) {
        return ShortObjToNilE.bind(this, sh);
    }

    /**
     * Binds {@code (u)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param u argument 2
     * @return a new function {@code (short sh) -> void} that calls
     *      {@code f.call(sh, u)}.
     */
    static <U, E extends Exception> net.mintern.functions.unary.checked.ShortToNilE<E>
    rbind(ShortObjToNilE<U, E> f, U u) {
        return (sh) -> f.call(sh, u);
    }

    /**
     * Binds {@code (u)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param u argument 2
     * @return a new function {@code (short sh) -> void} that calls
     *      {@code this.call(sh, u)}.
     */
    default net.mintern.functions.unary.checked.ShortToNilE<E> rbind(U u) {
        return ShortObjToNilE.rbind(this, u);
    }

    /**
     * Binds {@code (sh, u)} to {@code f}, returning a new function
     * of type {@code () -> void}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param u argument 2
     * @return a new function {@code () -> void} that calls
     *      {@code f.call(sh, u)}.
     */
    static <U, E extends Exception> net.mintern.functions.nullary.checked.NilToNilE<E>
    bind(ShortObjToNilE<U, E> f, short sh, U u) {
        return () -> f.call(sh, u);
    }

    /**
     * Binds {@code (sh, u)} to {@code this}, returning a new function
     * of type {@code () -> void}.
     *
     * @param sh argument 1
     * @param u argument 2
     * @return a new function {@code () -> void} that calls
     *      {@code this.call(sh, u)}.
     */
    default net.mintern.functions.nullary.checked.NilToNilE<E> bind(short sh, U u) {
        return ShortObjToNilE.bind(this, sh, u);
    }
}
