package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, U) -> R}.
 *
 * @param <U> the type of argument 2
 * @param <R> the type of the return value
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortObjToObjE<U, R, E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param u argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    R call(short sh, U u) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (U) -> R}.
     *
     * @param <U> the type of argument 2
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (U u) -> R} that calls
     *      {@code f.call(sh, u)} and returns the result.
     */
    static <U, R, E extends Exception> net.mintern.functions.unary.checked.ObjToObjE<U, R, E>
    bind(ShortObjToObjE<U, R, E> f, short sh) {
        return (u) -> f.call(sh, u);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (U) -> R}.
     *
     * @param sh argument 1
     * @return a new function {@code (U u) -> R} that calls
     *      {@code this.call(sh, u)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ObjToObjE<U, R, E> bind(short sh) {
        return ShortObjToObjE.bind(this, sh);
    }

    /**
     * Binds {@code (u)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param <U> the type of argument 2
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param u argument 2
     * @return a new function {@code (short sh) -> R} that calls
     *      {@code f.call(sh, u)} and returns the result.
     */
    static <U, R, E extends Exception> net.mintern.functions.unary.checked.ShortToObjE<R, E>
    rbind(ShortObjToObjE<U, R, E> f, U u) {
        return (sh) -> f.call(sh, u);
    }

    /**
     * Binds {@code (u)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param u argument 2
     * @return a new function {@code (short sh) -> R} that calls
     *      {@code this.call(sh, u)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToObjE<R, E> rbind(U u) {
        return ShortObjToObjE.rbind(this, u);
    }

    /**
     * Binds {@code (sh, u)} to {@code f}, returning a new function
     * of type {@code () -> R}.
     *
     * @param <U> the type of argument 2
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param u argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code f.call(sh, u)} and returns the result.
     */
    @SuppressWarnings("unchecked") // maven spuriously warns about a type error in this case
    static <U, R, E extends Exception> net.mintern.functions.nullary.checked.NilToObjE<R, E>
    bind(ShortObjToObjE<U, R, E> f, short sh, U u) {
        return () -> f.call(sh, u);
    }

    /**
     * Binds {@code (sh, u)} to {@code this}, returning a new function
     * of type {@code () -> R}.
     *
     * @param sh argument 1
     * @param u argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code this.call(sh, u)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToObjE<R, E> bind(short sh, U u) {
        return ShortObjToObjE.bind(this, sh, u);
    }
}
