package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, short) -> void}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortShortToNilE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh1 argument 1
     * @param sh2 argument 2
     * @throws E if the operation cannot be completed
     */
    void call(short sh1, short sh2) throws E;

    /**
     * Binds {@code (sh1)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh1 argument 1
     * @return a new function {@code (short sh2) -> void} that calls
     *      {@code f.call(sh1, sh2)}.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToNilE<E>
    bind(ShortShortToNilE<E> f, short sh1) {
        return (sh2) -> f.call(sh1, sh2);
    }

    /**
     * Binds {@code (sh1)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param sh1 argument 1
     * @return a new function {@code (short sh2) -> void} that calls
     *      {@code this.call(sh1, sh2)}.
     */
    default net.mintern.functions.unary.checked.ShortToNilE<E> bind(short sh1) {
        return ShortShortToNilE.bind(this, sh1);
    }

    /**
     * Binds {@code (sh2)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh2 argument 2
     * @return a new function {@code (short sh1) -> void} that calls
     *      {@code f.call(sh1, sh2)}.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToNilE<E>
    rbind(ShortShortToNilE<E> f, short sh2) {
        return (sh1) -> f.call(sh1, sh2);
    }

    /**
     * Binds {@code (sh2)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param sh2 argument 2
     * @return a new function {@code (short sh1) -> void} that calls
     *      {@code this.call(sh1, sh2)}.
     */
    default net.mintern.functions.unary.checked.ShortToNilE<E> rbind(short sh2) {
        return ShortShortToNilE.rbind(this, sh2);
    }

    /**
     * Binds {@code (sh1, sh2)} to {@code f}, returning a new function
     * of type {@code () -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh1 argument 1
     * @param sh2 argument 2
     * @return a new function {@code () -> void} that calls
     *      {@code f.call(sh1, sh2)}.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToNilE<E>
    bind(ShortShortToNilE<E> f, short sh1, short sh2) {
        return () -> f.call(sh1, sh2);
    }

    /**
     * Binds {@code (sh1, sh2)} to {@code this}, returning a new function
     * of type {@code () -> void}.
     *
     * @param sh1 argument 1
     * @param sh2 argument 2
     * @return a new function {@code () -> void} that calls
     *      {@code this.call(sh1, sh2)}.
     */
    default net.mintern.functions.nullary.checked.NilToNilE<E> bind(short sh1, short sh2) {
        return ShortShortToNilE.bind(this, sh1, sh2);
    }
}
