package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, short) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortShortToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh1 argument 1
     * @param sh2 argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(short sh1, short sh2) throws E;

    /**
     * Binds {@code (sh1)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh1 argument 1
     * @return a new function {@code (short sh2) -> short} that calls
     *      {@code f.call(sh1, sh2)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToShortE<E>
    bind(ShortShortToShortE<E> f, short sh1) {
        return (sh2) -> f.call(sh1, sh2);
    }

    /**
     * Binds {@code (sh1)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> short}.
     *
     * @param sh1 argument 1
     * @return a new function {@code (short sh2) -> short} that calls
     *      {@code this.call(sh1, sh2)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToShortE<E> bind(short sh1) {
        return ShortShortToShortE.bind(this, sh1);
    }

    /**
     * Binds {@code (sh2)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh2 argument 2
     * @return a new function {@code (short sh1) -> short} that calls
     *      {@code f.call(sh1, sh2)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToShortE<E>
    rbind(ShortShortToShortE<E> f, short sh2) {
        return (sh1) -> f.call(sh1, sh2);
    }

    /**
     * Binds {@code (sh2)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> short}.
     *
     * @param sh2 argument 2
     * @return a new function {@code (short sh1) -> short} that calls
     *      {@code this.call(sh1, sh2)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToShortE<E> rbind(short sh2) {
        return ShortShortToShortE.rbind(this, sh2);
    }

    /**
     * Binds {@code (sh1, sh2)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh1 argument 1
     * @param sh2 argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(sh1, sh2)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(ShortShortToShortE<E> f, short sh1, short sh2) {
        return () -> f.call(sh1, sh2);
    }

    /**
     * Binds {@code (sh1, sh2)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param sh1 argument 1
     * @param sh2 argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(sh1, sh2)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(short sh1, short sh2) {
        return ShortShortToShortE.bind(this, sh1, sh2);
    }
}
