/*
 * Decompiled with CFR 0.152.
 */
package net.mintern.functions.binary;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Function;
import net.mintern.functions.binary.checked.ByteCharToShortE;
import net.mintern.functions.nullary.NilToShort;
import net.mintern.functions.unary.ByteToShort;
import net.mintern.functions.unary.CharToShort;

@FunctionalInterface
public interface ByteCharToShort
extends ByteCharToShortE<RuntimeException> {
    public static <E extends Exception> ByteCharToShort unchecked(Function<? super E, RuntimeException> toRuntime, ByteCharToShortE<E> f) {
        return (b, ch) -> {
            try {
                return f.call(b, ch);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw (RuntimeException)toRuntime.apply((Object)e);
            }
        };
    }

    public static <E extends Exception> ByteCharToShort unchecked(ByteCharToShortE<E> f) {
        return ByteCharToShort.unchecked(RuntimeException::new, f);
    }

    public static <E extends IOException> ByteCharToShort uncheckedIO(ByteCharToShortE<E> f) {
        return ByteCharToShort.unchecked(UncheckedIOException::new, f);
    }

    public static CharToShort bind(ByteCharToShort f, byte b) {
        return ch -> f.call(b, ch);
    }

    default public CharToShort bind(byte b) {
        return ByteCharToShort.bind(this, b);
    }

    public static ByteToShort rbind(ByteCharToShort f, char ch) {
        return b -> f.call(b, ch);
    }

    default public ByteToShort rbind(char ch) {
        return ByteCharToShort.rbind(this, ch);
    }

    public static NilToShort bind(ByteCharToShort f, byte b, char ch) {
        return () -> f.call(b, ch);
    }

    default public NilToShort bind(byte b, char ch) {
        return ByteCharToShort.bind(this, b, ch);
    }
}

