/*
 * Decompiled with CFR 0.152.
 */
package net.mintern.functions.binary;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Function;
import net.mintern.functions.binary.checked.ByteShortToFloatE;
import net.mintern.functions.nullary.NilToFloat;
import net.mintern.functions.unary.ByteToFloat;
import net.mintern.functions.unary.ShortToFloat;

@FunctionalInterface
public interface ByteShortToFloat
extends ByteShortToFloatE<RuntimeException> {
    public static <E extends Exception> ByteShortToFloat unchecked(Function<? super E, RuntimeException> toRuntime, ByteShortToFloatE<E> f) {
        return (b, sh) -> {
            try {
                return f.call(b, sh);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw (RuntimeException)toRuntime.apply((Object)e);
            }
        };
    }

    public static <E extends Exception> ByteShortToFloat unchecked(ByteShortToFloatE<E> f) {
        return ByteShortToFloat.unchecked(RuntimeException::new, f);
    }

    public static <E extends IOException> ByteShortToFloat uncheckedIO(ByteShortToFloatE<E> f) {
        return ByteShortToFloat.unchecked(UncheckedIOException::new, f);
    }

    public static ShortToFloat bind(ByteShortToFloat f, byte b) {
        return sh -> f.call(b, sh);
    }

    default public ShortToFloat bind(byte b) {
        return ByteShortToFloat.bind(this, b);
    }

    public static ByteToFloat rbind(ByteShortToFloat f, short sh) {
        return b -> f.call(b, sh);
    }

    default public ByteToFloat rbind(short sh) {
        return ByteShortToFloat.rbind(this, sh);
    }

    public static NilToFloat bind(ByteShortToFloat f, byte b, short sh) {
        return () -> f.call(b, sh);
    }

    default public NilToFloat bind(byte b, short sh) {
        return ByteShortToFloat.bind(this, b, sh);
    }
}

