/*
 * Decompiled with CFR 0.152.
 */
package net.mintern.functions.binary;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Function;
import net.mintern.functions.binary.checked.ByteShortToLongE;
import net.mintern.functions.nullary.NilToLong;
import net.mintern.functions.unary.ByteToLong;
import net.mintern.functions.unary.ShortToLong;

@FunctionalInterface
public interface ByteShortToLong
extends ByteShortToLongE<RuntimeException> {
    public static <E extends Exception> ByteShortToLong unchecked(Function<? super E, RuntimeException> toRuntime, ByteShortToLongE<E> f) {
        return (b, sh) -> {
            try {
                return f.call(b, sh);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw (RuntimeException)toRuntime.apply((Object)e);
            }
        };
    }

    public static <E extends Exception> ByteShortToLong unchecked(ByteShortToLongE<E> f) {
        return ByteShortToLong.unchecked(RuntimeException::new, f);
    }

    public static <E extends IOException> ByteShortToLong uncheckedIO(ByteShortToLongE<E> f) {
        return ByteShortToLong.unchecked(UncheckedIOException::new, f);
    }

    public static ShortToLong bind(ByteShortToLong f, byte b) {
        return sh -> f.call(b, sh);
    }

    default public ShortToLong bind(byte b) {
        return ByteShortToLong.bind(this, b);
    }

    public static ByteToLong rbind(ByteShortToLong f, short sh) {
        return b -> f.call(b, sh);
    }

    default public ByteToLong rbind(short sh) {
        return ByteShortToLong.rbind(this, sh);
    }

    public static NilToLong bind(ByteShortToLong f, byte b, short sh) {
        return () -> f.call(b, sh);
    }

    default public NilToLong bind(byte b, short sh) {
        return ByteShortToLong.bind(this, b, sh);
    }
}

