/*
 * Decompiled with CFR 0.152.
 */
package net.mintern.functions.binary;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Function;
import net.mintern.functions.binary.checked.ByteShortToObjE;
import net.mintern.functions.nullary.NilToObj;
import net.mintern.functions.unary.ByteToObj;
import net.mintern.functions.unary.ShortToObj;

@FunctionalInterface
public interface ByteShortToObj<R>
extends ByteShortToObjE<R, RuntimeException> {
    public static <R, E extends Exception> ByteShortToObj<R> unchecked(Function<? super E, RuntimeException> toRuntime, ByteShortToObjE<R, E> f) {
        return (b, sh) -> {
            try {
                return f.call(b, sh);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw (RuntimeException)toRuntime.apply((Object)e);
            }
        };
    }

    public static <R, E extends Exception> ByteShortToObj<R> unchecked(ByteShortToObjE<R, E> f) {
        return ByteShortToObj.unchecked(RuntimeException::new, f);
    }

    public static <R, E extends IOException> ByteShortToObj<R> uncheckedIO(ByteShortToObjE<R, E> f) {
        return ByteShortToObj.unchecked(UncheckedIOException::new, f);
    }

    public static <R> ShortToObj<R> bind(ByteShortToObj<R> f, byte b) {
        return sh -> f.call(b, sh);
    }

    default public ShortToObj<R> bind(byte b) {
        return ByteShortToObj.bind(this, b);
    }

    public static <R> ByteToObj<R> rbind(ByteShortToObj<R> f, short sh) {
        return b -> f.call(b, sh);
    }

    default public ByteToObj<R> rbind(short sh) {
        return ByteShortToObj.rbind(this, sh);
    }

    public static <R> NilToObj<R> bind(ByteShortToObj<R> f, byte b, short sh) {
        return () -> f.call(b, sh);
    }

    default public NilToObj<R> bind(byte b, short sh) {
        return ByteShortToObj.bind(this, b, sh);
    }
}

