/*
 * Decompiled with CFR 0.152.
 */
package net.mintern.functions.binary;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Function;
import net.mintern.functions.binary.checked.IntShortToObjE;
import net.mintern.functions.nullary.NilToObj;
import net.mintern.functions.unary.IntToObj;
import net.mintern.functions.unary.ShortToObj;

@FunctionalInterface
public interface IntShortToObj<R>
extends IntShortToObjE<R, RuntimeException> {
    public static <R, E extends Exception> IntShortToObj<R> unchecked(Function<? super E, RuntimeException> toRuntime, IntShortToObjE<R, E> f) {
        return (i, sh) -> {
            try {
                return f.call(i, sh);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw (RuntimeException)toRuntime.apply((Object)e);
            }
        };
    }

    public static <R, E extends Exception> IntShortToObj<R> unchecked(IntShortToObjE<R, E> f) {
        return IntShortToObj.unchecked(RuntimeException::new, f);
    }

    public static <R, E extends IOException> IntShortToObj<R> uncheckedIO(IntShortToObjE<R, E> f) {
        return IntShortToObj.unchecked(UncheckedIOException::new, f);
    }

    public static <R> ShortToObj<R> bind(IntShortToObj<R> f, int i) {
        return sh -> f.call(i, sh);
    }

    default public ShortToObj<R> bind(int i) {
        return IntShortToObj.bind(this, i);
    }

    public static <R> IntToObj<R> rbind(IntShortToObj<R> f, short sh) {
        return i -> f.call(i, sh);
    }

    default public IntToObj<R> rbind(short sh) {
        return IntShortToObj.rbind(this, sh);
    }

    public static <R> NilToObj<R> bind(IntShortToObj<R> f, int i, short sh) {
        return () -> f.call(i, sh);
    }

    default public NilToObj<R> bind(int i, short sh) {
        return IntShortToObj.bind(this, i, sh);
    }
}

