/*
 * Decompiled with CFR 0.152.
 */
package net.mintern.functions.binary;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Function;
import net.mintern.functions.binary.checked.ObjShortToObjE;
import net.mintern.functions.nullary.NilToObj;
import net.mintern.functions.unary.ObjToObj;
import net.mintern.functions.unary.ShortToObj;

@FunctionalInterface
public interface ObjShortToObj<T, R>
extends ObjShortToObjE<T, R, RuntimeException> {
    public static <T, R, E extends Exception> ObjShortToObj<T, R> unchecked(Function<? super E, RuntimeException> toRuntime, ObjShortToObjE<T, R, E> f) {
        return (t, sh) -> {
            try {
                return f.call(t, sh);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw (RuntimeException)toRuntime.apply((Object)e);
            }
        };
    }

    public static <T, R, E extends Exception> ObjShortToObj<T, R> unchecked(ObjShortToObjE<T, R, E> f) {
        return ObjShortToObj.unchecked(RuntimeException::new, f);
    }

    public static <T, R, E extends IOException> ObjShortToObj<T, R> uncheckedIO(ObjShortToObjE<T, R, E> f) {
        return ObjShortToObj.unchecked(UncheckedIOException::new, f);
    }

    public static <T, R> ShortToObj<R> bind(ObjShortToObj<T, R> f, T t) {
        return sh -> f.call(t, sh);
    }

    default public ShortToObj<R> bind(T t) {
        return ObjShortToObj.bind(this, t);
    }

    public static <T, R> ObjToObj<T, R> rbind(ObjShortToObj<T, R> f, short sh) {
        return t -> f.call(t, sh);
    }

    default public ObjToObj<T, R> rbind(short sh) {
        return ObjShortToObj.rbind(this, sh);
    }

    public static <T, R> NilToObj<R> bind(ObjShortToObj<T, R> f, T t, short sh) {
        return () -> f.call(t, sh);
    }

    default public NilToObj<R> bind(T t, short sh) {
        return ObjShortToObj.bind(this, t, sh);
    }
}

