package net.mintern.functions.binary;

/**
 * An operation of type {@code (boolean, char) -> short}.
 *
 */
@FunctionalInterface
public interface BoolCharToShort extends
        net.mintern.functions.binary.checked.BoolCharToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.BoolCharToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> BoolCharToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.BoolCharToShortE<E> f) {
        return (bool, ch) -> {
            try {
                return f.call(bool, ch);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> BoolCharToShort unchecked(
            net.mintern.functions.binary.checked.BoolCharToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> BoolCharToShort uncheckedIO(
            net.mintern.functions.binary.checked.BoolCharToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (bool)} to the beginning of {@code f}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param f the unbound function
     * @param bool argument 1
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code f.call(bool, ch)} and returns the result.
     */
    static  net.mintern.functions.unary.CharToShort
    bind(BoolCharToShort f, boolean bool) {
        return (ch) -> f.call(bool, ch);
    }

    /**
     * Binds {@code (bool)} to the beginning of {@code this}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param bool argument 1
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code this.call(bool, ch)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.CharToShort bind(boolean bool) {
        return BoolCharToShort.bind(this, bool);
    }

    /**
     * Binds {@code (ch)} to the end of {@code f}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param f the unbound function
     * @param ch argument 2
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code f.call(bool, ch)} and returns the result.
     */
    static  net.mintern.functions.unary.BoolToShort
    rbind(BoolCharToShort f, char ch) {
        return (bool) -> f.call(bool, ch);
    }

    /**
     * Binds {@code (ch)} to the end of {@code this}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param ch argument 2
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code this.call(bool, ch)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.BoolToShort rbind(char ch) {
        return BoolCharToShort.rbind(this, ch);
    }

    /**
     * Binds {@code (bool, ch)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param bool argument 1
     * @param ch argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(bool, ch)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(BoolCharToShort f, boolean bool, char ch) {
        return () -> f.call(bool, ch);
    }

    /**
     * Binds {@code (bool, ch)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param bool argument 1
     * @param ch argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(bool, ch)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(boolean bool, char ch) {
        return BoolCharToShort.bind(this, bool, ch);
    }
}
