package net.mintern.functions.binary;

/**
 * An operation of type {@code (boolean, float) -> short}.
 *
 */
@FunctionalInterface
public interface BoolFloatToShort extends
        net.mintern.functions.binary.checked.BoolFloatToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.BoolFloatToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> BoolFloatToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.BoolFloatToShortE<E> f) {
        return (bool, fl) -> {
            try {
                return f.call(bool, fl);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> BoolFloatToShort unchecked(
            net.mintern.functions.binary.checked.BoolFloatToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> BoolFloatToShort uncheckedIO(
            net.mintern.functions.binary.checked.BoolFloatToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (bool)} to the beginning of {@code f}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param f the unbound function
     * @param bool argument 1
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code f.call(bool, fl)} and returns the result.
     */
    static  net.mintern.functions.unary.FloatToShort
    bind(BoolFloatToShort f, boolean bool) {
        return (fl) -> f.call(bool, fl);
    }

    /**
     * Binds {@code (bool)} to the beginning of {@code this}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param bool argument 1
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code this.call(bool, fl)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.FloatToShort bind(boolean bool) {
        return BoolFloatToShort.bind(this, bool);
    }

    /**
     * Binds {@code (fl)} to the end of {@code f}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param f the unbound function
     * @param fl argument 2
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code f.call(bool, fl)} and returns the result.
     */
    static  net.mintern.functions.unary.BoolToShort
    rbind(BoolFloatToShort f, float fl) {
        return (bool) -> f.call(bool, fl);
    }

    /**
     * Binds {@code (fl)} to the end of {@code this}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param fl argument 2
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code this.call(bool, fl)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.BoolToShort rbind(float fl) {
        return BoolFloatToShort.rbind(this, fl);
    }

    /**
     * Binds {@code (bool, fl)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param bool argument 1
     * @param fl argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(bool, fl)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(BoolFloatToShort f, boolean bool, float fl) {
        return () -> f.call(bool, fl);
    }

    /**
     * Binds {@code (bool, fl)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param bool argument 1
     * @param fl argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(bool, fl)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(boolean bool, float fl) {
        return BoolFloatToShort.bind(this, bool, fl);
    }
}
