package net.mintern.functions.binary;

/**
 * An operation of type {@code (boolean, int) -> short}.
 *
 */
@FunctionalInterface
public interface BoolIntToShort extends
        net.mintern.functions.binary.checked.BoolIntToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.BoolIntToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> BoolIntToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.BoolIntToShortE<E> f) {
        return (bool, i) -> {
            try {
                return f.call(bool, i);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> BoolIntToShort unchecked(
            net.mintern.functions.binary.checked.BoolIntToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> BoolIntToShort uncheckedIO(
            net.mintern.functions.binary.checked.BoolIntToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (bool)} to the beginning of {@code f}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param f the unbound function
     * @param bool argument 1
     * @return a new function {@code (int i) -> short} that calls
     *      {@code f.call(bool, i)} and returns the result.
     */
    static  net.mintern.functions.unary.IntToShort
    bind(BoolIntToShort f, boolean bool) {
        return (i) -> f.call(bool, i);
    }

    /**
     * Binds {@code (bool)} to the beginning of {@code this}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param bool argument 1
     * @return a new function {@code (int i) -> short} that calls
     *      {@code this.call(bool, i)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.IntToShort bind(boolean bool) {
        return BoolIntToShort.bind(this, bool);
    }

    /**
     * Binds {@code (i)} to the end of {@code f}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param f the unbound function
     * @param i argument 2
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code f.call(bool, i)} and returns the result.
     */
    static  net.mintern.functions.unary.BoolToShort
    rbind(BoolIntToShort f, int i) {
        return (bool) -> f.call(bool, i);
    }

    /**
     * Binds {@code (i)} to the end of {@code this}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param i argument 2
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code this.call(bool, i)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.BoolToShort rbind(int i) {
        return BoolIntToShort.rbind(this, i);
    }

    /**
     * Binds {@code (bool, i)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param bool argument 1
     * @param i argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(bool, i)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(BoolIntToShort f, boolean bool, int i) {
        return () -> f.call(bool, i);
    }

    /**
     * Binds {@code (bool, i)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param bool argument 1
     * @param i argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(bool, i)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(boolean bool, int i) {
        return BoolIntToShort.bind(this, bool, i);
    }
}
