package net.mintern.functions.binary;

/**
 * An operation of type {@code (boolean, long) -> short}.
 *
 */
@FunctionalInterface
public interface BoolLongToShort extends
        net.mintern.functions.binary.checked.BoolLongToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.BoolLongToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> BoolLongToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.BoolLongToShortE<E> f) {
        return (bool, l) -> {
            try {
                return f.call(bool, l);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> BoolLongToShort unchecked(
            net.mintern.functions.binary.checked.BoolLongToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> BoolLongToShort uncheckedIO(
            net.mintern.functions.binary.checked.BoolLongToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (bool)} to the beginning of {@code f}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param f the unbound function
     * @param bool argument 1
     * @return a new function {@code (long l) -> short} that calls
     *      {@code f.call(bool, l)} and returns the result.
     */
    static  net.mintern.functions.unary.LongToShort
    bind(BoolLongToShort f, boolean bool) {
        return (l) -> f.call(bool, l);
    }

    /**
     * Binds {@code (bool)} to the beginning of {@code this}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param bool argument 1
     * @return a new function {@code (long l) -> short} that calls
     *      {@code this.call(bool, l)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.LongToShort bind(boolean bool) {
        return BoolLongToShort.bind(this, bool);
    }

    /**
     * Binds {@code (l)} to the end of {@code f}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param f the unbound function
     * @param l argument 2
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code f.call(bool, l)} and returns the result.
     */
    static  net.mintern.functions.unary.BoolToShort
    rbind(BoolLongToShort f, long l) {
        return (bool) -> f.call(bool, l);
    }

    /**
     * Binds {@code (l)} to the end of {@code this}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param l argument 2
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code this.call(bool, l)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.BoolToShort rbind(long l) {
        return BoolLongToShort.rbind(this, l);
    }

    /**
     * Binds {@code (bool, l)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param bool argument 1
     * @param l argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(bool, l)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(BoolLongToShort f, boolean bool, long l) {
        return () -> f.call(bool, l);
    }

    /**
     * Binds {@code (bool, l)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param bool argument 1
     * @param l argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(bool, l)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(boolean bool, long l) {
        return BoolLongToShort.bind(this, bool, l);
    }
}
