package net.mintern.functions.binary;

/**
 * An operation of type {@code (boolean, short) -> void}.
 *
 */
@FunctionalInterface
public interface BoolShortToNil extends
        net.mintern.functions.binary.checked.BoolShortToNilE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.BoolShortToNilE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> BoolShortToNil unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.BoolShortToNilE<E> f) {
        return (bool, sh) -> {
            try {
                f.call(bool, sh);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> BoolShortToNil unchecked(
            net.mintern.functions.binary.checked.BoolShortToNilE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> BoolShortToNil uncheckedIO(
            net.mintern.functions.binary.checked.BoolShortToNilE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (bool)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param f the unbound function
     * @param bool argument 1
     * @return a new function {@code (short sh) -> void} that calls
     *      {@code f.call(bool, sh)}.
     */
    static  net.mintern.functions.unary.ShortToNil
    bind(BoolShortToNil f, boolean bool) {
        return (sh) -> f.call(bool, sh);
    }

    /**
     * Binds {@code (bool)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param bool argument 1
     * @return a new function {@code (short sh) -> void} that calls
     *      {@code this.call(bool, sh)}.
     */
    @Override
    default net.mintern.functions.unary.ShortToNil bind(boolean bool) {
        return BoolShortToNil.bind(this, bool);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (boolean) -> void}.
     *
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (boolean bool) -> void} that calls
     *      {@code f.call(bool, sh)}.
     */
    static  net.mintern.functions.unary.BoolToNil
    rbind(BoolShortToNil f, short sh) {
        return (bool) -> f.call(bool, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (boolean) -> void}.
     *
     * @param sh argument 2
     * @return a new function {@code (boolean bool) -> void} that calls
     *      {@code this.call(bool, sh)}.
     */
    @Override
    default net.mintern.functions.unary.BoolToNil rbind(short sh) {
        return BoolShortToNil.rbind(this, sh);
    }

    /**
     * Binds {@code (bool, sh)} to {@code f}, returning a new function
     * of type {@code () -> void}.
     *
     * @param f the unbound function
     * @param bool argument 1
     * @param sh argument 2
     * @return a new function {@code () -> void} that calls
     *      {@code f.call(bool, sh)}.
     */
    static  net.mintern.functions.nullary.NilToNil
    bind(BoolShortToNil f, boolean bool, short sh) {
        return () -> f.call(bool, sh);
    }

    /**
     * Binds {@code (bool, sh)} to {@code this}, returning a new function
     * of type {@code () -> void}.
     *
     * @param bool argument 1
     * @param sh argument 2
     * @return a new function {@code () -> void} that calls
     *      {@code this.call(bool, sh)}.
     */
    @Override
    default net.mintern.functions.nullary.NilToNil bind(boolean bool, short sh) {
        return BoolShortToNil.bind(this, bool, sh);
    }
}
