package net.mintern.functions.binary;

/**
 * An operation of type {@code (boolean, short) -> R}.
 *
 * @param <R> the type of the return value
 */
@FunctionalInterface
public interface BoolShortToObj<R> extends
        net.mintern.functions.binary.checked.BoolShortToObjE<R, RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.BoolShortToObjE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <R, E extends Exception> BoolShortToObj<R> unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.BoolShortToObjE<R, E> f) {
        return (bool, sh) -> {
            try {
                return f.call(bool, sh);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <R, E extends Exception> BoolShortToObj<R> unchecked(
            net.mintern.functions.binary.checked.BoolShortToObjE<R, E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <R, E extends java.io.IOException> BoolShortToObj<R> uncheckedIO(
            net.mintern.functions.binary.checked.BoolShortToObjE<R, E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (bool)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param <R> the type of the return value
     * @param f the unbound function
     * @param bool argument 1
     * @return a new function {@code (short sh) -> R} that calls
     *      {@code f.call(bool, sh)} and returns the result.
     */
    static <R> net.mintern.functions.unary.ShortToObj<R>
    bind(BoolShortToObj<R> f, boolean bool) {
        return (sh) -> f.call(bool, sh);
    }

    /**
     * Binds {@code (bool)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param bool argument 1
     * @return a new function {@code (short sh) -> R} that calls
     *      {@code this.call(bool, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToObj<R> bind(boolean bool) {
        return BoolShortToObj.bind(this, bool);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (boolean) -> R}.
     *
     * @param <R> the type of the return value
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (boolean bool) -> R} that calls
     *      {@code f.call(bool, sh)} and returns the result.
     */
    static <R> net.mintern.functions.unary.BoolToObj<R>
    rbind(BoolShortToObj<R> f, short sh) {
        return (bool) -> f.call(bool, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (boolean) -> R}.
     *
     * @param sh argument 2
     * @return a new function {@code (boolean bool) -> R} that calls
     *      {@code this.call(bool, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.BoolToObj<R> rbind(short sh) {
        return BoolShortToObj.rbind(this, sh);
    }

    /**
     * Binds {@code (bool, sh)} to {@code f}, returning a new function
     * of type {@code () -> R}.
     *
     * @param <R> the type of the return value
     * @param f the unbound function
     * @param bool argument 1
     * @param sh argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code f.call(bool, sh)} and returns the result.
     */
    static <R> net.mintern.functions.nullary.NilToObj<R>
    bind(BoolShortToObj<R> f, boolean bool, short sh) {
        return () -> f.call(bool, sh);
    }

    /**
     * Binds {@code (bool, sh)} to {@code this}, returning a new function
     * of type {@code () -> R}.
     *
     * @param bool argument 1
     * @param sh argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code this.call(bool, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToObj<R> bind(boolean bool, short sh) {
        return BoolShortToObj.bind(this, bool, sh);
    }
}
