package net.mintern.functions.binary;

/**
 * An operation of type {@code (byte, byte) -> short}.
 *
 */
@FunctionalInterface
public interface ByteByteToShort extends
        net.mintern.functions.binary.checked.ByteByteToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ByteByteToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> ByteByteToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ByteByteToShortE<E> f) {
        return (b1, b2) -> {
            try {
                return f.call(b1, b2);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> ByteByteToShort unchecked(
            net.mintern.functions.binary.checked.ByteByteToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> ByteByteToShort uncheckedIO(
            net.mintern.functions.binary.checked.ByteByteToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (b1)} to the beginning of {@code f}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param f the unbound function
     * @param b1 argument 1
     * @return a new function {@code (byte b2) -> short} that calls
     *      {@code f.call(b1, b2)} and returns the result.
     */
    static  net.mintern.functions.unary.ByteToShort
    bind(ByteByteToShort f, byte b1) {
        return (b2) -> f.call(b1, b2);
    }

    /**
     * Binds {@code (b1)} to the beginning of {@code this}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param b1 argument 1
     * @return a new function {@code (byte b2) -> short} that calls
     *      {@code this.call(b1, b2)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ByteToShort bind(byte b1) {
        return ByteByteToShort.bind(this, b1);
    }

    /**
     * Binds {@code (b2)} to the end of {@code f}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param f the unbound function
     * @param b2 argument 2
     * @return a new function {@code (byte b1) -> short} that calls
     *      {@code f.call(b1, b2)} and returns the result.
     */
    static  net.mintern.functions.unary.ByteToShort
    rbind(ByteByteToShort f, byte b2) {
        return (b1) -> f.call(b1, b2);
    }

    /**
     * Binds {@code (b2)} to the end of {@code this}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param b2 argument 2
     * @return a new function {@code (byte b1) -> short} that calls
     *      {@code this.call(b1, b2)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ByteToShort rbind(byte b2) {
        return ByteByteToShort.rbind(this, b2);
    }

    /**
     * Binds {@code (b1, b2)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param b1 argument 1
     * @param b2 argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(b1, b2)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(ByteByteToShort f, byte b1, byte b2) {
        return () -> f.call(b1, b2);
    }

    /**
     * Binds {@code (b1, b2)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param b1 argument 1
     * @param b2 argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(b1, b2)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(byte b1, byte b2) {
        return ByteByteToShort.bind(this, b1, b2);
    }
}
