package net.mintern.functions.binary;

/**
 * An operation of type {@code (byte, double) -> short}.
 *
 */
@FunctionalInterface
public interface ByteDblToShort extends
        net.mintern.functions.binary.checked.ByteDblToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ByteDblToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> ByteDblToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ByteDblToShortE<E> f) {
        return (b, d) -> {
            try {
                return f.call(b, d);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> ByteDblToShort unchecked(
            net.mintern.functions.binary.checked.ByteDblToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> ByteDblToShort uncheckedIO(
            net.mintern.functions.binary.checked.ByteDblToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (b)} to the beginning of {@code f}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param f the unbound function
     * @param b argument 1
     * @return a new function {@code (double d) -> short} that calls
     *      {@code f.call(b, d)} and returns the result.
     */
    static  net.mintern.functions.unary.DblToShort
    bind(ByteDblToShort f, byte b) {
        return (d) -> f.call(b, d);
    }

    /**
     * Binds {@code (b)} to the beginning of {@code this}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param b argument 1
     * @return a new function {@code (double d) -> short} that calls
     *      {@code this.call(b, d)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.DblToShort bind(byte b) {
        return ByteDblToShort.bind(this, b);
    }

    /**
     * Binds {@code (d)} to the end of {@code f}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param f the unbound function
     * @param d argument 2
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code f.call(b, d)} and returns the result.
     */
    static  net.mintern.functions.unary.ByteToShort
    rbind(ByteDblToShort f, double d) {
        return (b) -> f.call(b, d);
    }

    /**
     * Binds {@code (d)} to the end of {@code this}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param d argument 2
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code this.call(b, d)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ByteToShort rbind(double d) {
        return ByteDblToShort.rbind(this, d);
    }

    /**
     * Binds {@code (b, d)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param b argument 1
     * @param d argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(b, d)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(ByteDblToShort f, byte b, double d) {
        return () -> f.call(b, d);
    }

    /**
     * Binds {@code (b, d)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param b argument 1
     * @param d argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(b, d)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(byte b, double d) {
        return ByteDblToShort.bind(this, b, d);
    }
}
