package net.mintern.functions.binary;

/**
 * An operation of type {@code (byte, long) -> short}.
 *
 */
@FunctionalInterface
public interface ByteLongToShort extends
        net.mintern.functions.binary.checked.ByteLongToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ByteLongToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> ByteLongToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ByteLongToShortE<E> f) {
        return (b, l) -> {
            try {
                return f.call(b, l);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> ByteLongToShort unchecked(
            net.mintern.functions.binary.checked.ByteLongToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> ByteLongToShort uncheckedIO(
            net.mintern.functions.binary.checked.ByteLongToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (b)} to the beginning of {@code f}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param f the unbound function
     * @param b argument 1
     * @return a new function {@code (long l) -> short} that calls
     *      {@code f.call(b, l)} and returns the result.
     */
    static  net.mintern.functions.unary.LongToShort
    bind(ByteLongToShort f, byte b) {
        return (l) -> f.call(b, l);
    }

    /**
     * Binds {@code (b)} to the beginning of {@code this}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param b argument 1
     * @return a new function {@code (long l) -> short} that calls
     *      {@code this.call(b, l)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.LongToShort bind(byte b) {
        return ByteLongToShort.bind(this, b);
    }

    /**
     * Binds {@code (l)} to the end of {@code f}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param f the unbound function
     * @param l argument 2
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code f.call(b, l)} and returns the result.
     */
    static  net.mintern.functions.unary.ByteToShort
    rbind(ByteLongToShort f, long l) {
        return (b) -> f.call(b, l);
    }

    /**
     * Binds {@code (l)} to the end of {@code this}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param l argument 2
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code this.call(b, l)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ByteToShort rbind(long l) {
        return ByteLongToShort.rbind(this, l);
    }

    /**
     * Binds {@code (b, l)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param b argument 1
     * @param l argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(b, l)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(ByteLongToShort f, byte b, long l) {
        return () -> f.call(b, l);
    }

    /**
     * Binds {@code (b, l)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param b argument 1
     * @param l argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(b, l)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(byte b, long l) {
        return ByteLongToShort.bind(this, b, l);
    }
}
