package net.mintern.functions.binary;

/**
 * An operation of type {@code (byte, U) -> short}.
 *
 * @param <U> the type of the argument
 */
@FunctionalInterface
public interface ByteObjToShort<U> extends
        net.mintern.functions.binary.checked.ByteObjToShortE<U, RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ByteObjToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <U, E extends Exception> ByteObjToShort<U> unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ByteObjToShortE<U, E> f) {
        return (b, u) -> {
            try {
                return f.call(b, u);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <U, E extends Exception> ByteObjToShort<U> unchecked(
            net.mintern.functions.binary.checked.ByteObjToShortE<U, E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <U, E extends java.io.IOException> ByteObjToShort<U> uncheckedIO(
            net.mintern.functions.binary.checked.ByteObjToShortE<U, E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (b)} to the beginning of {@code f}, returning a new function
     * of type {@code (U) -> short}.
     *
     * @param <U> the type of the argument
     * @param f the unbound function
     * @param b argument 1
     * @return a new function {@code (U u) -> short} that calls
     *      {@code f.call(b, u)} and returns the result.
     */
    static <U> net.mintern.functions.unary.ObjToShort<U>
    bind(ByteObjToShort<U> f, byte b) {
        return (u) -> f.call(b, u);
    }

    /**
     * Binds {@code (b)} to the beginning of {@code this}, returning a new function
     * of type {@code (U) -> short}.
     *
     * @param b argument 1
     * @return a new function {@code (U u) -> short} that calls
     *      {@code this.call(b, u)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ObjToShort<U> bind(byte b) {
        return ByteObjToShort.bind(this, b);
    }

    /**
     * Binds {@code (u)} to the end of {@code f}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param <U> the type of the argument
     * @param f the unbound function
     * @param u argument 2
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code f.call(b, u)} and returns the result.
     */
    static <U> net.mintern.functions.unary.ByteToShort
    rbind(ByteObjToShort<U> f, U u) {
        return (b) -> f.call(b, u);
    }

    /**
     * Binds {@code (u)} to the end of {@code this}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param u argument 2
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code this.call(b, u)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ByteToShort rbind(U u) {
        return ByteObjToShort.rbind(this, u);
    }

    /**
     * Binds {@code (b, u)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <U> the type of the argument
     * @param f the unbound function
     * @param b argument 1
     * @param u argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(b, u)} and returns the result.
     */
    static <U> net.mintern.functions.nullary.NilToShort
    bind(ByteObjToShort<U> f, byte b, U u) {
        return () -> f.call(b, u);
    }

    /**
     * Binds {@code (b, u)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param b argument 1
     * @param u argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(b, u)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(byte b, U u) {
        return ByteObjToShort.bind(this, b, u);
    }
}
