package net.mintern.functions.binary;

/**
 * An operation of type {@code (byte, short) -> byte}.
 *
 */
@FunctionalInterface
public interface ByteShortToByte extends
        net.mintern.functions.binary.checked.ByteShortToByteE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ByteShortToByteE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> ByteShortToByte unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ByteShortToByteE<E> f) {
        return (b, sh) -> {
            try {
                return f.call(b, sh);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> ByteShortToByte unchecked(
            net.mintern.functions.binary.checked.ByteShortToByteE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> ByteShortToByte uncheckedIO(
            net.mintern.functions.binary.checked.ByteShortToByteE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (b)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> byte}.
     *
     * @param f the unbound function
     * @param b argument 1
     * @return a new function {@code (short sh) -> byte} that calls
     *      {@code f.call(b, sh)} and returns the result.
     */
    static  net.mintern.functions.unary.ShortToByte
    bind(ByteShortToByte f, byte b) {
        return (sh) -> f.call(b, sh);
    }

    /**
     * Binds {@code (b)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> byte}.
     *
     * @param b argument 1
     * @return a new function {@code (short sh) -> byte} that calls
     *      {@code this.call(b, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToByte bind(byte b) {
        return ByteShortToByte.bind(this, b);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (byte) -> byte}.
     *
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (byte b) -> byte} that calls
     *      {@code f.call(b, sh)} and returns the result.
     */
    static  net.mintern.functions.unary.ByteToByte
    rbind(ByteShortToByte f, short sh) {
        return (b) -> f.call(b, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (byte) -> byte}.
     *
     * @param sh argument 2
     * @return a new function {@code (byte b) -> byte} that calls
     *      {@code this.call(b, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ByteToByte rbind(short sh) {
        return ByteShortToByte.rbind(this, sh);
    }

    /**
     * Binds {@code (b, sh)} to {@code f}, returning a new function
     * of type {@code () -> byte}.
     *
     * @param f the unbound function
     * @param b argument 1
     * @param sh argument 2
     * @return a new function {@code () -> byte} that calls
     *      {@code f.call(b, sh)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToByte
    bind(ByteShortToByte f, byte b, short sh) {
        return () -> f.call(b, sh);
    }

    /**
     * Binds {@code (b, sh)} to {@code this}, returning a new function
     * of type {@code () -> byte}.
     *
     * @param b argument 1
     * @param sh argument 2
     * @return a new function {@code () -> byte} that calls
     *      {@code this.call(b, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToByte bind(byte b, short sh) {
        return ByteShortToByte.bind(this, b, sh);
    }
}
