package net.mintern.functions.binary;

/**
 * An operation of type {@code (byte, short) -> double}.
 *
 */
@FunctionalInterface
public interface ByteShortToDbl extends
        net.mintern.functions.binary.checked.ByteShortToDblE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ByteShortToDblE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> ByteShortToDbl unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ByteShortToDblE<E> f) {
        return (b, sh) -> {
            try {
                return f.call(b, sh);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> ByteShortToDbl unchecked(
            net.mintern.functions.binary.checked.ByteShortToDblE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> ByteShortToDbl uncheckedIO(
            net.mintern.functions.binary.checked.ByteShortToDblE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (b)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> double}.
     *
     * @param f the unbound function
     * @param b argument 1
     * @return a new function {@code (short sh) -> double} that calls
     *      {@code f.call(b, sh)} and returns the result.
     */
    static  net.mintern.functions.unary.ShortToDbl
    bind(ByteShortToDbl f, byte b) {
        return (sh) -> f.call(b, sh);
    }

    /**
     * Binds {@code (b)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> double}.
     *
     * @param b argument 1
     * @return a new function {@code (short sh) -> double} that calls
     *      {@code this.call(b, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToDbl bind(byte b) {
        return ByteShortToDbl.bind(this, b);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (byte) -> double}.
     *
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (byte b) -> double} that calls
     *      {@code f.call(b, sh)} and returns the result.
     */
    static  net.mintern.functions.unary.ByteToDbl
    rbind(ByteShortToDbl f, short sh) {
        return (b) -> f.call(b, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (byte) -> double}.
     *
     * @param sh argument 2
     * @return a new function {@code (byte b) -> double} that calls
     *      {@code this.call(b, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ByteToDbl rbind(short sh) {
        return ByteShortToDbl.rbind(this, sh);
    }

    /**
     * Binds {@code (b, sh)} to {@code f}, returning a new function
     * of type {@code () -> double}.
     *
     * @param f the unbound function
     * @param b argument 1
     * @param sh argument 2
     * @return a new function {@code () -> double} that calls
     *      {@code f.call(b, sh)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToDbl
    bind(ByteShortToDbl f, byte b, short sh) {
        return () -> f.call(b, sh);
    }

    /**
     * Binds {@code (b, sh)} to {@code this}, returning a new function
     * of type {@code () -> double}.
     *
     * @param b argument 1
     * @param sh argument 2
     * @return a new function {@code () -> double} that calls
     *      {@code this.call(b, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToDbl bind(byte b, short sh) {
        return ByteShortToDbl.bind(this, b, sh);
    }
}
