package net.mintern.functions.binary;

/**
 * An operation of type {@code (char, boolean) -> short}.
 *
 */
@FunctionalInterface
public interface CharBoolToShort extends
        net.mintern.functions.binary.checked.CharBoolToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.CharBoolToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> CharBoolToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.CharBoolToShortE<E> f) {
        return (ch, bool) -> {
            try {
                return f.call(ch, bool);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> CharBoolToShort unchecked(
            net.mintern.functions.binary.checked.CharBoolToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> CharBoolToShort uncheckedIO(
            net.mintern.functions.binary.checked.CharBoolToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (ch)} to the beginning of {@code f}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param f the unbound function
     * @param ch argument 1
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code f.call(ch, bool)} and returns the result.
     */
    static  net.mintern.functions.unary.BoolToShort
    bind(CharBoolToShort f, char ch) {
        return (bool) -> f.call(ch, bool);
    }

    /**
     * Binds {@code (ch)} to the beginning of {@code this}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param ch argument 1
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code this.call(ch, bool)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.BoolToShort bind(char ch) {
        return CharBoolToShort.bind(this, ch);
    }

    /**
     * Binds {@code (bool)} to the end of {@code f}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param f the unbound function
     * @param bool argument 2
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code f.call(ch, bool)} and returns the result.
     */
    static  net.mintern.functions.unary.CharToShort
    rbind(CharBoolToShort f, boolean bool) {
        return (ch) -> f.call(ch, bool);
    }

    /**
     * Binds {@code (bool)} to the end of {@code this}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param bool argument 2
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code this.call(ch, bool)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.CharToShort rbind(boolean bool) {
        return CharBoolToShort.rbind(this, bool);
    }

    /**
     * Binds {@code (ch, bool)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param ch argument 1
     * @param bool argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(ch, bool)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(CharBoolToShort f, char ch, boolean bool) {
        return () -> f.call(ch, bool);
    }

    /**
     * Binds {@code (ch, bool)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param ch argument 1
     * @param bool argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(ch, bool)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(char ch, boolean bool) {
        return CharBoolToShort.bind(this, ch, bool);
    }
}
