package net.mintern.functions.binary;

/**
 * An operation of type {@code (char, int) -> short}.
 *
 */
@FunctionalInterface
public interface CharIntToShort extends
        net.mintern.functions.binary.checked.CharIntToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.CharIntToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> CharIntToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.CharIntToShortE<E> f) {
        return (ch, i) -> {
            try {
                return f.call(ch, i);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> CharIntToShort unchecked(
            net.mintern.functions.binary.checked.CharIntToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> CharIntToShort uncheckedIO(
            net.mintern.functions.binary.checked.CharIntToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (ch)} to the beginning of {@code f}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param f the unbound function
     * @param ch argument 1
     * @return a new function {@code (int i) -> short} that calls
     *      {@code f.call(ch, i)} and returns the result.
     */
    static  net.mintern.functions.unary.IntToShort
    bind(CharIntToShort f, char ch) {
        return (i) -> f.call(ch, i);
    }

    /**
     * Binds {@code (ch)} to the beginning of {@code this}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param ch argument 1
     * @return a new function {@code (int i) -> short} that calls
     *      {@code this.call(ch, i)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.IntToShort bind(char ch) {
        return CharIntToShort.bind(this, ch);
    }

    /**
     * Binds {@code (i)} to the end of {@code f}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param f the unbound function
     * @param i argument 2
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code f.call(ch, i)} and returns the result.
     */
    static  net.mintern.functions.unary.CharToShort
    rbind(CharIntToShort f, int i) {
        return (ch) -> f.call(ch, i);
    }

    /**
     * Binds {@code (i)} to the end of {@code this}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param i argument 2
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code this.call(ch, i)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.CharToShort rbind(int i) {
        return CharIntToShort.rbind(this, i);
    }

    /**
     * Binds {@code (ch, i)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param ch argument 1
     * @param i argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(ch, i)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(CharIntToShort f, char ch, int i) {
        return () -> f.call(ch, i);
    }

    /**
     * Binds {@code (ch, i)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param ch argument 1
     * @param i argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(ch, i)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(char ch, int i) {
        return CharIntToShort.bind(this, ch, i);
    }
}
