package net.mintern.functions.binary;

/**
 * An operation of type {@code (char, long) -> short}.
 *
 */
@FunctionalInterface
public interface CharLongToShort extends
        net.mintern.functions.binary.checked.CharLongToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.CharLongToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> CharLongToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.CharLongToShortE<E> f) {
        return (ch, l) -> {
            try {
                return f.call(ch, l);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> CharLongToShort unchecked(
            net.mintern.functions.binary.checked.CharLongToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> CharLongToShort uncheckedIO(
            net.mintern.functions.binary.checked.CharLongToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (ch)} to the beginning of {@code f}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param f the unbound function
     * @param ch argument 1
     * @return a new function {@code (long l) -> short} that calls
     *      {@code f.call(ch, l)} and returns the result.
     */
    static  net.mintern.functions.unary.LongToShort
    bind(CharLongToShort f, char ch) {
        return (l) -> f.call(ch, l);
    }

    /**
     * Binds {@code (ch)} to the beginning of {@code this}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param ch argument 1
     * @return a new function {@code (long l) -> short} that calls
     *      {@code this.call(ch, l)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.LongToShort bind(char ch) {
        return CharLongToShort.bind(this, ch);
    }

    /**
     * Binds {@code (l)} to the end of {@code f}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param f the unbound function
     * @param l argument 2
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code f.call(ch, l)} and returns the result.
     */
    static  net.mintern.functions.unary.CharToShort
    rbind(CharLongToShort f, long l) {
        return (ch) -> f.call(ch, l);
    }

    /**
     * Binds {@code (l)} to the end of {@code this}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param l argument 2
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code this.call(ch, l)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.CharToShort rbind(long l) {
        return CharLongToShort.rbind(this, l);
    }

    /**
     * Binds {@code (ch, l)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param ch argument 1
     * @param l argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(ch, l)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(CharLongToShort f, char ch, long l) {
        return () -> f.call(ch, l);
    }

    /**
     * Binds {@code (ch, l)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param ch argument 1
     * @param l argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(ch, l)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(char ch, long l) {
        return CharLongToShort.bind(this, ch, l);
    }
}
