package net.mintern.functions.binary;

/**
 * An operation of type {@code (char, U) -> short}.
 *
 * @param <U> the type of the argument
 */
@FunctionalInterface
public interface CharObjToShort<U> extends
        net.mintern.functions.binary.checked.CharObjToShortE<U, RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.CharObjToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <U, E extends Exception> CharObjToShort<U> unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.CharObjToShortE<U, E> f) {
        return (ch, u) -> {
            try {
                return f.call(ch, u);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <U, E extends Exception> CharObjToShort<U> unchecked(
            net.mintern.functions.binary.checked.CharObjToShortE<U, E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <U, E extends java.io.IOException> CharObjToShort<U> uncheckedIO(
            net.mintern.functions.binary.checked.CharObjToShortE<U, E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (ch)} to the beginning of {@code f}, returning a new function
     * of type {@code (U) -> short}.
     *
     * @param <U> the type of the argument
     * @param f the unbound function
     * @param ch argument 1
     * @return a new function {@code (U u) -> short} that calls
     *      {@code f.call(ch, u)} and returns the result.
     */
    static <U> net.mintern.functions.unary.ObjToShort<U>
    bind(CharObjToShort<U> f, char ch) {
        return (u) -> f.call(ch, u);
    }

    /**
     * Binds {@code (ch)} to the beginning of {@code this}, returning a new function
     * of type {@code (U) -> short}.
     *
     * @param ch argument 1
     * @return a new function {@code (U u) -> short} that calls
     *      {@code this.call(ch, u)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ObjToShort<U> bind(char ch) {
        return CharObjToShort.bind(this, ch);
    }

    /**
     * Binds {@code (u)} to the end of {@code f}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param <U> the type of the argument
     * @param f the unbound function
     * @param u argument 2
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code f.call(ch, u)} and returns the result.
     */
    static <U> net.mintern.functions.unary.CharToShort
    rbind(CharObjToShort<U> f, U u) {
        return (ch) -> f.call(ch, u);
    }

    /**
     * Binds {@code (u)} to the end of {@code this}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param u argument 2
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code this.call(ch, u)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.CharToShort rbind(U u) {
        return CharObjToShort.rbind(this, u);
    }

    /**
     * Binds {@code (ch, u)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <U> the type of the argument
     * @param f the unbound function
     * @param ch argument 1
     * @param u argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(ch, u)} and returns the result.
     */
    static <U> net.mintern.functions.nullary.NilToShort
    bind(CharObjToShort<U> f, char ch, U u) {
        return () -> f.call(ch, u);
    }

    /**
     * Binds {@code (ch, u)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param ch argument 1
     * @param u argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(ch, u)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(char ch, U u) {
        return CharObjToShort.bind(this, ch, u);
    }
}
