package net.mintern.functions.binary;

/**
 * An operation of type {@code (char, short) -> boolean}.
 *
 */
@FunctionalInterface
public interface CharShortToBool extends
        net.mintern.functions.binary.checked.CharShortToBoolE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.CharShortToBoolE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> CharShortToBool unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.CharShortToBoolE<E> f) {
        return (ch, sh) -> {
            try {
                return f.call(ch, sh);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> CharShortToBool unchecked(
            net.mintern.functions.binary.checked.CharShortToBoolE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> CharShortToBool uncheckedIO(
            net.mintern.functions.binary.checked.CharShortToBoolE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (ch)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> boolean}.
     *
     * @param f the unbound function
     * @param ch argument 1
     * @return a new function {@code (short sh) -> boolean} that calls
     *      {@code f.call(ch, sh)} and returns the result.
     */
    static  net.mintern.functions.unary.ShortToBool
    bind(CharShortToBool f, char ch) {
        return (sh) -> f.call(ch, sh);
    }

    /**
     * Binds {@code (ch)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> boolean}.
     *
     * @param ch argument 1
     * @return a new function {@code (short sh) -> boolean} that calls
     *      {@code this.call(ch, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToBool bind(char ch) {
        return CharShortToBool.bind(this, ch);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (char) -> boolean}.
     *
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (char ch) -> boolean} that calls
     *      {@code f.call(ch, sh)} and returns the result.
     */
    static  net.mintern.functions.unary.CharToBool
    rbind(CharShortToBool f, short sh) {
        return (ch) -> f.call(ch, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (char) -> boolean}.
     *
     * @param sh argument 2
     * @return a new function {@code (char ch) -> boolean} that calls
     *      {@code this.call(ch, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.CharToBool rbind(short sh) {
        return CharShortToBool.rbind(this, sh);
    }

    /**
     * Binds {@code (ch, sh)} to {@code f}, returning a new function
     * of type {@code () -> boolean}.
     *
     * @param f the unbound function
     * @param ch argument 1
     * @param sh argument 2
     * @return a new function {@code () -> boolean} that calls
     *      {@code f.call(ch, sh)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToBool
    bind(CharShortToBool f, char ch, short sh) {
        return () -> f.call(ch, sh);
    }

    /**
     * Binds {@code (ch, sh)} to {@code this}, returning a new function
     * of type {@code () -> boolean}.
     *
     * @param ch argument 1
     * @param sh argument 2
     * @return a new function {@code () -> boolean} that calls
     *      {@code this.call(ch, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToBool bind(char ch, short sh) {
        return CharShortToBool.bind(this, ch, sh);
    }
}
