package net.mintern.functions.binary;

/**
 * An operation of type {@code (double, byte) -> short}.
 *
 */
@FunctionalInterface
public interface DblByteToShort extends
        net.mintern.functions.binary.checked.DblByteToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.DblByteToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> DblByteToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.DblByteToShortE<E> f) {
        return (d, b) -> {
            try {
                return f.call(d, b);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> DblByteToShort unchecked(
            net.mintern.functions.binary.checked.DblByteToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> DblByteToShort uncheckedIO(
            net.mintern.functions.binary.checked.DblByteToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (d)} to the beginning of {@code f}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param f the unbound function
     * @param d argument 1
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code f.call(d, b)} and returns the result.
     */
    static  net.mintern.functions.unary.ByteToShort
    bind(DblByteToShort f, double d) {
        return (b) -> f.call(d, b);
    }

    /**
     * Binds {@code (d)} to the beginning of {@code this}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param d argument 1
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code this.call(d, b)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ByteToShort bind(double d) {
        return DblByteToShort.bind(this, d);
    }

    /**
     * Binds {@code (b)} to the end of {@code f}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param f the unbound function
     * @param b argument 2
     * @return a new function {@code (double d) -> short} that calls
     *      {@code f.call(d, b)} and returns the result.
     */
    static  net.mintern.functions.unary.DblToShort
    rbind(DblByteToShort f, byte b) {
        return (d) -> f.call(d, b);
    }

    /**
     * Binds {@code (b)} to the end of {@code this}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param b argument 2
     * @return a new function {@code (double d) -> short} that calls
     *      {@code this.call(d, b)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.DblToShort rbind(byte b) {
        return DblByteToShort.rbind(this, b);
    }

    /**
     * Binds {@code (d, b)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param d argument 1
     * @param b argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(d, b)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(DblByteToShort f, double d, byte b) {
        return () -> f.call(d, b);
    }

    /**
     * Binds {@code (d, b)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param d argument 1
     * @param b argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(d, b)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(double d, byte b) {
        return DblByteToShort.bind(this, d, b);
    }
}
