package net.mintern.functions.binary;

/**
 * An operation of type {@code (double, U) -> short}.
 *
 * @param <U> the type of the argument
 */
@FunctionalInterface
public interface DblObjToShort<U> extends
        net.mintern.functions.binary.checked.DblObjToShortE<U, RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.DblObjToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <U, E extends Exception> DblObjToShort<U> unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.DblObjToShortE<U, E> f) {
        return (d, u) -> {
            try {
                return f.call(d, u);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <U, E extends Exception> DblObjToShort<U> unchecked(
            net.mintern.functions.binary.checked.DblObjToShortE<U, E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <U, E extends java.io.IOException> DblObjToShort<U> uncheckedIO(
            net.mintern.functions.binary.checked.DblObjToShortE<U, E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (d)} to the beginning of {@code f}, returning a new function
     * of type {@code (U) -> short}.
     *
     * @param <U> the type of the argument
     * @param f the unbound function
     * @param d argument 1
     * @return a new function {@code (U u) -> short} that calls
     *      {@code f.call(d, u)} and returns the result.
     */
    static <U> net.mintern.functions.unary.ObjToShort<U>
    bind(DblObjToShort<U> f, double d) {
        return (u) -> f.call(d, u);
    }

    /**
     * Binds {@code (d)} to the beginning of {@code this}, returning a new function
     * of type {@code (U) -> short}.
     *
     * @param d argument 1
     * @return a new function {@code (U u) -> short} that calls
     *      {@code this.call(d, u)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ObjToShort<U> bind(double d) {
        return DblObjToShort.bind(this, d);
    }

    /**
     * Binds {@code (u)} to the end of {@code f}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param <U> the type of the argument
     * @param f the unbound function
     * @param u argument 2
     * @return a new function {@code (double d) -> short} that calls
     *      {@code f.call(d, u)} and returns the result.
     */
    static <U> net.mintern.functions.unary.DblToShort
    rbind(DblObjToShort<U> f, U u) {
        return (d) -> f.call(d, u);
    }

    /**
     * Binds {@code (u)} to the end of {@code this}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param u argument 2
     * @return a new function {@code (double d) -> short} that calls
     *      {@code this.call(d, u)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.DblToShort rbind(U u) {
        return DblObjToShort.rbind(this, u);
    }

    /**
     * Binds {@code (d, u)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <U> the type of the argument
     * @param f the unbound function
     * @param d argument 1
     * @param u argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(d, u)} and returns the result.
     */
    static <U> net.mintern.functions.nullary.NilToShort
    bind(DblObjToShort<U> f, double d, U u) {
        return () -> f.call(d, u);
    }

    /**
     * Binds {@code (d, u)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param d argument 1
     * @param u argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(d, u)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(double d, U u) {
        return DblObjToShort.bind(this, d, u);
    }
}
