package net.mintern.functions.binary;

/**
 * An operation of type {@code (double, short) -> R}.
 *
 * @param <R> the type of the return value
 */
@FunctionalInterface
public interface DblShortToObj<R> extends
        net.mintern.functions.binary.checked.DblShortToObjE<R, RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.DblShortToObjE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <R, E extends Exception> DblShortToObj<R> unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.DblShortToObjE<R, E> f) {
        return (d, sh) -> {
            try {
                return f.call(d, sh);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <R, E extends Exception> DblShortToObj<R> unchecked(
            net.mintern.functions.binary.checked.DblShortToObjE<R, E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <R, E extends java.io.IOException> DblShortToObj<R> uncheckedIO(
            net.mintern.functions.binary.checked.DblShortToObjE<R, E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (d)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param <R> the type of the return value
     * @param f the unbound function
     * @param d argument 1
     * @return a new function {@code (short sh) -> R} that calls
     *      {@code f.call(d, sh)} and returns the result.
     */
    static <R> net.mintern.functions.unary.ShortToObj<R>
    bind(DblShortToObj<R> f, double d) {
        return (sh) -> f.call(d, sh);
    }

    /**
     * Binds {@code (d)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param d argument 1
     * @return a new function {@code (short sh) -> R} that calls
     *      {@code this.call(d, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToObj<R> bind(double d) {
        return DblShortToObj.bind(this, d);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (double) -> R}.
     *
     * @param <R> the type of the return value
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (double d) -> R} that calls
     *      {@code f.call(d, sh)} and returns the result.
     */
    static <R> net.mintern.functions.unary.DblToObj<R>
    rbind(DblShortToObj<R> f, short sh) {
        return (d) -> f.call(d, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (double) -> R}.
     *
     * @param sh argument 2
     * @return a new function {@code (double d) -> R} that calls
     *      {@code this.call(d, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.DblToObj<R> rbind(short sh) {
        return DblShortToObj.rbind(this, sh);
    }

    /**
     * Binds {@code (d, sh)} to {@code f}, returning a new function
     * of type {@code () -> R}.
     *
     * @param <R> the type of the return value
     * @param f the unbound function
     * @param d argument 1
     * @param sh argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code f.call(d, sh)} and returns the result.
     */
    static <R> net.mintern.functions.nullary.NilToObj<R>
    bind(DblShortToObj<R> f, double d, short sh) {
        return () -> f.call(d, sh);
    }

    /**
     * Binds {@code (d, sh)} to {@code this}, returning a new function
     * of type {@code () -> R}.
     *
     * @param d argument 1
     * @param sh argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code this.call(d, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToObj<R> bind(double d, short sh) {
        return DblShortToObj.bind(this, d, sh);
    }
}
