package net.mintern.functions.binary;

/**
 * An operation of type {@code (float, double) -> short}.
 *
 */
@FunctionalInterface
public interface FloatDblToShort extends
        net.mintern.functions.binary.checked.FloatDblToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.FloatDblToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> FloatDblToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.FloatDblToShortE<E> f) {
        return (fl, d) -> {
            try {
                return f.call(fl, d);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> FloatDblToShort unchecked(
            net.mintern.functions.binary.checked.FloatDblToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> FloatDblToShort uncheckedIO(
            net.mintern.functions.binary.checked.FloatDblToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (fl)} to the beginning of {@code f}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param f the unbound function
     * @param fl argument 1
     * @return a new function {@code (double d) -> short} that calls
     *      {@code f.call(fl, d)} and returns the result.
     */
    static  net.mintern.functions.unary.DblToShort
    bind(FloatDblToShort f, float fl) {
        return (d) -> f.call(fl, d);
    }

    /**
     * Binds {@code (fl)} to the beginning of {@code this}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param fl argument 1
     * @return a new function {@code (double d) -> short} that calls
     *      {@code this.call(fl, d)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.DblToShort bind(float fl) {
        return FloatDblToShort.bind(this, fl);
    }

    /**
     * Binds {@code (d)} to the end of {@code f}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param f the unbound function
     * @param d argument 2
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code f.call(fl, d)} and returns the result.
     */
    static  net.mintern.functions.unary.FloatToShort
    rbind(FloatDblToShort f, double d) {
        return (fl) -> f.call(fl, d);
    }

    /**
     * Binds {@code (d)} to the end of {@code this}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param d argument 2
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code this.call(fl, d)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.FloatToShort rbind(double d) {
        return FloatDblToShort.rbind(this, d);
    }

    /**
     * Binds {@code (fl, d)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param fl argument 1
     * @param d argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(fl, d)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(FloatDblToShort f, float fl, double d) {
        return () -> f.call(fl, d);
    }

    /**
     * Binds {@code (fl, d)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param fl argument 1
     * @param d argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(fl, d)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(float fl, double d) {
        return FloatDblToShort.bind(this, fl, d);
    }
}
