package net.mintern.functions.binary;

/**
 * An operation of type {@code (float, float) -> short}.
 *
 */
@FunctionalInterface
public interface FloatFloatToShort extends
        net.mintern.functions.binary.checked.FloatFloatToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.FloatFloatToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> FloatFloatToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.FloatFloatToShortE<E> f) {
        return (fl1, fl2) -> {
            try {
                return f.call(fl1, fl2);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> FloatFloatToShort unchecked(
            net.mintern.functions.binary.checked.FloatFloatToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> FloatFloatToShort uncheckedIO(
            net.mintern.functions.binary.checked.FloatFloatToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (fl1)} to the beginning of {@code f}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param f the unbound function
     * @param fl1 argument 1
     * @return a new function {@code (float fl2) -> short} that calls
     *      {@code f.call(fl1, fl2)} and returns the result.
     */
    static  net.mintern.functions.unary.FloatToShort
    bind(FloatFloatToShort f, float fl1) {
        return (fl2) -> f.call(fl1, fl2);
    }

    /**
     * Binds {@code (fl1)} to the beginning of {@code this}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param fl1 argument 1
     * @return a new function {@code (float fl2) -> short} that calls
     *      {@code this.call(fl1, fl2)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.FloatToShort bind(float fl1) {
        return FloatFloatToShort.bind(this, fl1);
    }

    /**
     * Binds {@code (fl2)} to the end of {@code f}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param f the unbound function
     * @param fl2 argument 2
     * @return a new function {@code (float fl1) -> short} that calls
     *      {@code f.call(fl1, fl2)} and returns the result.
     */
    static  net.mintern.functions.unary.FloatToShort
    rbind(FloatFloatToShort f, float fl2) {
        return (fl1) -> f.call(fl1, fl2);
    }

    /**
     * Binds {@code (fl2)} to the end of {@code this}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param fl2 argument 2
     * @return a new function {@code (float fl1) -> short} that calls
     *      {@code this.call(fl1, fl2)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.FloatToShort rbind(float fl2) {
        return FloatFloatToShort.rbind(this, fl2);
    }

    /**
     * Binds {@code (fl1, fl2)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param fl1 argument 1
     * @param fl2 argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(fl1, fl2)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(FloatFloatToShort f, float fl1, float fl2) {
        return () -> f.call(fl1, fl2);
    }

    /**
     * Binds {@code (fl1, fl2)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param fl1 argument 1
     * @param fl2 argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(fl1, fl2)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(float fl1, float fl2) {
        return FloatFloatToShort.bind(this, fl1, fl2);
    }
}
