package net.mintern.functions.binary;

/**
 * An operation of type {@code (float, short) -> short}.
 *
 */
@FunctionalInterface
public interface FloatShortToShort extends
        net.mintern.functions.binary.checked.FloatShortToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.FloatShortToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> FloatShortToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.FloatShortToShortE<E> f) {
        return (fl, sh) -> {
            try {
                return f.call(fl, sh);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> FloatShortToShort unchecked(
            net.mintern.functions.binary.checked.FloatShortToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> FloatShortToShort uncheckedIO(
            net.mintern.functions.binary.checked.FloatShortToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (fl)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> short}.
     *
     * @param f the unbound function
     * @param fl argument 1
     * @return a new function {@code (short sh) -> short} that calls
     *      {@code f.call(fl, sh)} and returns the result.
     */
    static  net.mintern.functions.unary.ShortToShort
    bind(FloatShortToShort f, float fl) {
        return (sh) -> f.call(fl, sh);
    }

    /**
     * Binds {@code (fl)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> short}.
     *
     * @param fl argument 1
     * @return a new function {@code (short sh) -> short} that calls
     *      {@code this.call(fl, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToShort bind(float fl) {
        return FloatShortToShort.bind(this, fl);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code f.call(fl, sh)} and returns the result.
     */
    static  net.mintern.functions.unary.FloatToShort
    rbind(FloatShortToShort f, short sh) {
        return (fl) -> f.call(fl, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param sh argument 2
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code this.call(fl, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.FloatToShort rbind(short sh) {
        return FloatShortToShort.rbind(this, sh);
    }

    /**
     * Binds {@code (fl, sh)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param fl argument 1
     * @param sh argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(fl, sh)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(FloatShortToShort f, float fl, short sh) {
        return () -> f.call(fl, sh);
    }

    /**
     * Binds {@code (fl, sh)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param fl argument 1
     * @param sh argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(fl, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(float fl, short sh) {
        return FloatShortToShort.bind(this, fl, sh);
    }
}
