package net.mintern.functions.binary;

/**
 * An operation of type {@code (int, boolean) -> short}.
 *
 */
@FunctionalInterface
public interface IntBoolToShort extends
        net.mintern.functions.binary.checked.IntBoolToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.IntBoolToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> IntBoolToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.IntBoolToShortE<E> f) {
        return (i, bool) -> {
            try {
                return f.call(i, bool);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> IntBoolToShort unchecked(
            net.mintern.functions.binary.checked.IntBoolToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> IntBoolToShort uncheckedIO(
            net.mintern.functions.binary.checked.IntBoolToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (i)} to the beginning of {@code f}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param f the unbound function
     * @param i argument 1
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code f.call(i, bool)} and returns the result.
     */
    static  net.mintern.functions.unary.BoolToShort
    bind(IntBoolToShort f, int i) {
        return (bool) -> f.call(i, bool);
    }

    /**
     * Binds {@code (i)} to the beginning of {@code this}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param i argument 1
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code this.call(i, bool)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.BoolToShort bind(int i) {
        return IntBoolToShort.bind(this, i);
    }

    /**
     * Binds {@code (bool)} to the end of {@code f}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param f the unbound function
     * @param bool argument 2
     * @return a new function {@code (int i) -> short} that calls
     *      {@code f.call(i, bool)} and returns the result.
     */
    static  net.mintern.functions.unary.IntToShort
    rbind(IntBoolToShort f, boolean bool) {
        return (i) -> f.call(i, bool);
    }

    /**
     * Binds {@code (bool)} to the end of {@code this}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param bool argument 2
     * @return a new function {@code (int i) -> short} that calls
     *      {@code this.call(i, bool)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.IntToShort rbind(boolean bool) {
        return IntBoolToShort.rbind(this, bool);
    }

    /**
     * Binds {@code (i, bool)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param i argument 1
     * @param bool argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(i, bool)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(IntBoolToShort f, int i, boolean bool) {
        return () -> f.call(i, bool);
    }

    /**
     * Binds {@code (i, bool)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param i argument 1
     * @param bool argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(i, bool)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(int i, boolean bool) {
        return IntBoolToShort.bind(this, i, bool);
    }
}
