package net.mintern.functions.binary;

/**
 * An operation of type {@code (int, byte) -> short}.
 *
 */
@FunctionalInterface
public interface IntByteToShort extends
        net.mintern.functions.binary.checked.IntByteToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.IntByteToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> IntByteToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.IntByteToShortE<E> f) {
        return (i, b) -> {
            try {
                return f.call(i, b);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> IntByteToShort unchecked(
            net.mintern.functions.binary.checked.IntByteToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> IntByteToShort uncheckedIO(
            net.mintern.functions.binary.checked.IntByteToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (i)} to the beginning of {@code f}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param f the unbound function
     * @param i argument 1
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code f.call(i, b)} and returns the result.
     */
    static  net.mintern.functions.unary.ByteToShort
    bind(IntByteToShort f, int i) {
        return (b) -> f.call(i, b);
    }

    /**
     * Binds {@code (i)} to the beginning of {@code this}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param i argument 1
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code this.call(i, b)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ByteToShort bind(int i) {
        return IntByteToShort.bind(this, i);
    }

    /**
     * Binds {@code (b)} to the end of {@code f}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param f the unbound function
     * @param b argument 2
     * @return a new function {@code (int i) -> short} that calls
     *      {@code f.call(i, b)} and returns the result.
     */
    static  net.mintern.functions.unary.IntToShort
    rbind(IntByteToShort f, byte b) {
        return (i) -> f.call(i, b);
    }

    /**
     * Binds {@code (b)} to the end of {@code this}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param b argument 2
     * @return a new function {@code (int i) -> short} that calls
     *      {@code this.call(i, b)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.IntToShort rbind(byte b) {
        return IntByteToShort.rbind(this, b);
    }

    /**
     * Binds {@code (i, b)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param i argument 1
     * @param b argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(i, b)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(IntByteToShort f, int i, byte b) {
        return () -> f.call(i, b);
    }

    /**
     * Binds {@code (i, b)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param i argument 1
     * @param b argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(i, b)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(int i, byte b) {
        return IntByteToShort.bind(this, i, b);
    }
}
