package net.mintern.functions.binary;

/**
 * An operation of type {@code (int, char) -> short}.
 *
 */
@FunctionalInterface
public interface IntCharToShort extends
        net.mintern.functions.binary.checked.IntCharToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.IntCharToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> IntCharToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.IntCharToShortE<E> f) {
        return (i, ch) -> {
            try {
                return f.call(i, ch);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> IntCharToShort unchecked(
            net.mintern.functions.binary.checked.IntCharToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> IntCharToShort uncheckedIO(
            net.mintern.functions.binary.checked.IntCharToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (i)} to the beginning of {@code f}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param f the unbound function
     * @param i argument 1
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code f.call(i, ch)} and returns the result.
     */
    static  net.mintern.functions.unary.CharToShort
    bind(IntCharToShort f, int i) {
        return (ch) -> f.call(i, ch);
    }

    /**
     * Binds {@code (i)} to the beginning of {@code this}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param i argument 1
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code this.call(i, ch)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.CharToShort bind(int i) {
        return IntCharToShort.bind(this, i);
    }

    /**
     * Binds {@code (ch)} to the end of {@code f}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param f the unbound function
     * @param ch argument 2
     * @return a new function {@code (int i) -> short} that calls
     *      {@code f.call(i, ch)} and returns the result.
     */
    static  net.mintern.functions.unary.IntToShort
    rbind(IntCharToShort f, char ch) {
        return (i) -> f.call(i, ch);
    }

    /**
     * Binds {@code (ch)} to the end of {@code this}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param ch argument 2
     * @return a new function {@code (int i) -> short} that calls
     *      {@code this.call(i, ch)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.IntToShort rbind(char ch) {
        return IntCharToShort.rbind(this, ch);
    }

    /**
     * Binds {@code (i, ch)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param i argument 1
     * @param ch argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(i, ch)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(IntCharToShort f, int i, char ch) {
        return () -> f.call(i, ch);
    }

    /**
     * Binds {@code (i, ch)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param i argument 1
     * @param ch argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(i, ch)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(int i, char ch) {
        return IntCharToShort.bind(this, i, ch);
    }
}
