package net.mintern.functions.binary;

/**
 * An operation of type {@code (int, long) -> short}.
 *
 */
@FunctionalInterface
public interface IntLongToShort extends
        net.mintern.functions.binary.checked.IntLongToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.IntLongToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> IntLongToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.IntLongToShortE<E> f) {
        return (i, l) -> {
            try {
                return f.call(i, l);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> IntLongToShort unchecked(
            net.mintern.functions.binary.checked.IntLongToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> IntLongToShort uncheckedIO(
            net.mintern.functions.binary.checked.IntLongToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (i)} to the beginning of {@code f}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param f the unbound function
     * @param i argument 1
     * @return a new function {@code (long l) -> short} that calls
     *      {@code f.call(i, l)} and returns the result.
     */
    static  net.mintern.functions.unary.LongToShort
    bind(IntLongToShort f, int i) {
        return (l) -> f.call(i, l);
    }

    /**
     * Binds {@code (i)} to the beginning of {@code this}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param i argument 1
     * @return a new function {@code (long l) -> short} that calls
     *      {@code this.call(i, l)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.LongToShort bind(int i) {
        return IntLongToShort.bind(this, i);
    }

    /**
     * Binds {@code (l)} to the end of {@code f}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param f the unbound function
     * @param l argument 2
     * @return a new function {@code (int i) -> short} that calls
     *      {@code f.call(i, l)} and returns the result.
     */
    static  net.mintern.functions.unary.IntToShort
    rbind(IntLongToShort f, long l) {
        return (i) -> f.call(i, l);
    }

    /**
     * Binds {@code (l)} to the end of {@code this}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param l argument 2
     * @return a new function {@code (int i) -> short} that calls
     *      {@code this.call(i, l)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.IntToShort rbind(long l) {
        return IntLongToShort.rbind(this, l);
    }

    /**
     * Binds {@code (i, l)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param i argument 1
     * @param l argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(i, l)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(IntLongToShort f, int i, long l) {
        return () -> f.call(i, l);
    }

    /**
     * Binds {@code (i, l)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param i argument 1
     * @param l argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(i, l)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(int i, long l) {
        return IntLongToShort.bind(this, i, l);
    }
}
