package net.mintern.functions.binary;

/**
 * An operation of type {@code (int, U) -> short}.
 *
 * @param <U> the type of the argument
 */
@FunctionalInterface
public interface IntObjToShort<U> extends
        net.mintern.functions.binary.checked.IntObjToShortE<U, RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.IntObjToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <U, E extends Exception> IntObjToShort<U> unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.IntObjToShortE<U, E> f) {
        return (i, u) -> {
            try {
                return f.call(i, u);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <U, E extends Exception> IntObjToShort<U> unchecked(
            net.mintern.functions.binary.checked.IntObjToShortE<U, E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <U, E extends java.io.IOException> IntObjToShort<U> uncheckedIO(
            net.mintern.functions.binary.checked.IntObjToShortE<U, E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (i)} to the beginning of {@code f}, returning a new function
     * of type {@code (U) -> short}.
     *
     * @param <U> the type of the argument
     * @param f the unbound function
     * @param i argument 1
     * @return a new function {@code (U u) -> short} that calls
     *      {@code f.call(i, u)} and returns the result.
     */
    static <U> net.mintern.functions.unary.ObjToShort<U>
    bind(IntObjToShort<U> f, int i) {
        return (u) -> f.call(i, u);
    }

    /**
     * Binds {@code (i)} to the beginning of {@code this}, returning a new function
     * of type {@code (U) -> short}.
     *
     * @param i argument 1
     * @return a new function {@code (U u) -> short} that calls
     *      {@code this.call(i, u)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ObjToShort<U> bind(int i) {
        return IntObjToShort.bind(this, i);
    }

    /**
     * Binds {@code (u)} to the end of {@code f}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param <U> the type of the argument
     * @param f the unbound function
     * @param u argument 2
     * @return a new function {@code (int i) -> short} that calls
     *      {@code f.call(i, u)} and returns the result.
     */
    static <U> net.mintern.functions.unary.IntToShort
    rbind(IntObjToShort<U> f, U u) {
        return (i) -> f.call(i, u);
    }

    /**
     * Binds {@code (u)} to the end of {@code this}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param u argument 2
     * @return a new function {@code (int i) -> short} that calls
     *      {@code this.call(i, u)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.IntToShort rbind(U u) {
        return IntObjToShort.rbind(this, u);
    }

    /**
     * Binds {@code (i, u)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <U> the type of the argument
     * @param f the unbound function
     * @param i argument 1
     * @param u argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(i, u)} and returns the result.
     */
    static <U> net.mintern.functions.nullary.NilToShort
    bind(IntObjToShort<U> f, int i, U u) {
        return () -> f.call(i, u);
    }

    /**
     * Binds {@code (i, u)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param i argument 1
     * @param u argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(i, u)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(int i, U u) {
        return IntObjToShort.bind(this, i, u);
    }
}
