package net.mintern.functions.binary;

/**
 * An operation of type {@code (long, boolean) -> short}.
 *
 */
@FunctionalInterface
public interface LongBoolToShort extends
        net.mintern.functions.binary.checked.LongBoolToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.LongBoolToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> LongBoolToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.LongBoolToShortE<E> f) {
        return (l, bool) -> {
            try {
                return f.call(l, bool);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> LongBoolToShort unchecked(
            net.mintern.functions.binary.checked.LongBoolToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> LongBoolToShort uncheckedIO(
            net.mintern.functions.binary.checked.LongBoolToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (l)} to the beginning of {@code f}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param f the unbound function
     * @param l argument 1
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code f.call(l, bool)} and returns the result.
     */
    static  net.mintern.functions.unary.BoolToShort
    bind(LongBoolToShort f, long l) {
        return (bool) -> f.call(l, bool);
    }

    /**
     * Binds {@code (l)} to the beginning of {@code this}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param l argument 1
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code this.call(l, bool)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.BoolToShort bind(long l) {
        return LongBoolToShort.bind(this, l);
    }

    /**
     * Binds {@code (bool)} to the end of {@code f}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param f the unbound function
     * @param bool argument 2
     * @return a new function {@code (long l) -> short} that calls
     *      {@code f.call(l, bool)} and returns the result.
     */
    static  net.mintern.functions.unary.LongToShort
    rbind(LongBoolToShort f, boolean bool) {
        return (l) -> f.call(l, bool);
    }

    /**
     * Binds {@code (bool)} to the end of {@code this}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param bool argument 2
     * @return a new function {@code (long l) -> short} that calls
     *      {@code this.call(l, bool)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.LongToShort rbind(boolean bool) {
        return LongBoolToShort.rbind(this, bool);
    }

    /**
     * Binds {@code (l, bool)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param l argument 1
     * @param bool argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(l, bool)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(LongBoolToShort f, long l, boolean bool) {
        return () -> f.call(l, bool);
    }

    /**
     * Binds {@code (l, bool)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param l argument 1
     * @param bool argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(l, bool)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(long l, boolean bool) {
        return LongBoolToShort.bind(this, l, bool);
    }
}
